package com.bokesoft.yes.meta.json.com.comp;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.common.MetaPara;
import com.bokesoft.yigo.meta.common.MetaParas;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGantt;

public class MetaGanttJSONHandler extends BaseComponentJSONHandler<MetaGantt> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaGantt meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_SCALE, meta.getScale());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_ITEMSPERPAGE, meta.getItemsPerPage());
		
		MetaParas metaParas = meta.getParas();
		if( metaParas != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, metaParas);
			JSONHelper.writeToJSON(json, JSONConstants.MAP_PARAS, array);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaGantt meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setScale(json.optInt(JSONConstants.GANTT_SCALE));
		meta.setItemsPerPage(json.optInt(JSONConstants.GANTT_ITEMSPERPAGE));
		
		JSONArray array = json.optJSONArray(JSONConstants.MAP_PARAS);
		if( array != null ) {
			MetaParas metaParas = new MetaParas();
			List<MetaPara> list = UIJSONHandlerUtil.unbuild(MetaPara.class, array);
			metaParas.addAll(list);
			meta.setParas(metaParas);
		}
	}

	@Override
	public MetaGantt newInstance() {
		return new MetaGantt();
	}

}
