package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDrawerBox;

public class MetaDrawerBoxJSONHandler extends BaseComponentJSONHandler<MetaDrawerBox> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDrawerBox meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		// 子组件反序列化
		JSONArray items = new JSONArray();
		for ( int i = 0,count = meta.getComponentCount(); i < count; ++i ) {
			MetaComponent metaChild = meta.getComponent(i);
			JSONObject childJSON = UIJSONHandlerUtil.build(metaChild,hook);
			items.put(childJSON);
		}
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, items);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ORIENTATION, meta.getOrientation());
		JSONHelper.writeToJSON(json, JSONConstants.DRAWERBOX_ISEXPAND, meta.getIsExpand());
		JSONHelper.writeToJSON(json, JSONConstants.DRAWERBOX_INDICATORBACKCOLOR, meta.getIndicatorBackColor());
	}
	
	@Override
	public void fromJSONImpl(MetaDrawerBox meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		// 子组件序列化
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		for( int i = 0,size = array.length();i < size;i++ ) {
			JSONObject o = array.optJSONObject(i);
			MetaComponent child = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.addComponent(child);
		}
		meta.setOrientation(json.optInt(JSONConstants.COMMON_ORIENTATION));
		meta.setIsExpand(JSONHelper.readFromJSON(json, JSONConstants.DRAWERBOX_ISEXPAND, false));
		meta.setIndicatorBackColor(JSONHelper.readFromJSON(json, JSONConstants.DRAWERBOX_INDICATORBACKCOLOR, ""));
	}

	@Override
	public MetaDrawerBox newInstance() {
		return new MetaDrawerBox();
	}

}