package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.MetaBatchImageUploader;

public class MetaBatchImageUploaderJSONHandler extends BaseComponentJSONHandler<MetaBatchImageUploader> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaBatchImageUploader meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);

		JSONHelper.writeToJSON(json, JSONConstants.BATCHIMAGEUPLOADER_MAXSIZE,meta.getMaxSize());
		JSONHelper.writeToJSON(json, JSONConstants.BATCHIMAGEUPLOADER_MAXCOUNT,meta.getMaxCount());
	}
	
	@Override
	public void fromJSONImpl(MetaBatchImageUploader meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setMaxSize(json.optInt(JSONConstants.BATCHIMAGEUPLOADER_MAXSIZE, -1));
		meta.setMaxCount(json.optInt(JSONConstants.BATCHIMAGEUPLOADER_MAXCOUNT, -1));
	}

	@Override
	public MetaBatchImageUploader newInstance() {
		return new MetaBatchImageUploader();
	}
}
