package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.timer.action.TimerMidFormula;

public class TimerMidFormulaJSONHandler extends AbstractJSONHandler<TimerMidFormula, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(TimerMidFormula meta, JSONObject json) throws Throwable {
		meta.setFormula(json.optString(JSONConstants.TIMER_FORMULA));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, TimerMidFormula meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_FORMULA, meta.getFormula());
		
	}
	
	@Override
	public TimerMidFormula newInstance() {
		return new TimerMidFormula();
	}
}
