package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.timer.MetaTimerTask;
import com.bokesoft.yigo.meta.timer.action.MetaAbstractAction;
import com.bokesoft.yigo.meta.timer.action.TimerMidFormula;
import com.bokesoft.yigo.meta.timer.action.TimerSeDevClass;
import com.bokesoft.yigo.meta.timer.action.TimerWorkitemCommit;
import com.bokesoft.yigo.meta.timer.period.Moment;
import com.bokesoft.yigo.meta.timer.period.Period;
import com.bokesoft.yigo.meta.timer.period.WorkDay;

public class MetaTimerTaskJOSNHandler extends AbstractJSONHandler<MetaTimerTask, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaTimerTask meta, JSONObject json) throws Throwable {
		JSONObject o = json.optJSONObject(JSONConstants.BPM_PERIOD);
		if(o != null){
			String tagName = o.optString(JSONConstants.BPM_TAGNAME);
			if(Moment.TAG_NAME.equalsIgnoreCase(tagName)){
				meta.setPeriod(BPMJSONHandlerUtil.unbuild(Moment.class, o));
			}else if(WorkDay.TAG_NAME.equalsIgnoreCase(tagName)){
				meta.setPeriod(BPMJSONHandlerUtil.unbuild(WorkDay.class, o));
			}
		}
		o = json.optJSONObject(JSONConstants.BPM_TIMERACTION);
		if(o != null){
			String tagName = o.optString(JSONConstants.BPM_TAGNAME);
			if(TimerMidFormula.TAG_NAME.equalsIgnoreCase(tagName)){
				meta.setTimerAction(BPMJSONHandlerUtil.unbuild(TimerMidFormula.class, o));
			}else if(TimerSeDevClass.TAG_NAME.equalsIgnoreCase(tagName)){
				meta.setTimerAction(BPMJSONHandlerUtil.unbuild(TimerSeDevClass.class, o));
			}else if(TimerWorkitemCommit.TAG_NAME.equalsIgnoreCase(tagName)){
				meta.setTimerAction(BPMJSONHandlerUtil.unbuild(TimerWorkitemCommit.class, o));
			}
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTimerTask meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		
		Period period = meta.getPeriod();
		if(period != null){
			JSONObject o = BPMJSONHandlerUtil.build(period, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_PERIOD, o);
		}
		MetaAbstractAction timerAction = meta.getTimerAction();
		if(timerAction != null){
			JSONObject o = BPMJSONHandlerUtil.build(timerAction, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_TIMERACTION, o);
		}
		
	}
	
	@Override
	public MetaTimerTask newInstance() {
		return new MetaTimerTask();
	}
}
