package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTableTrigger;

public class MetaTableTriggerJSONHandler extends AbstractJSONHandler<MetaTableTrigger, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaTableTrigger meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setColumnListStr(json.optString(JSONConstants.COLUMN_LIST_STR));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTableTrigger meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_LIST_STR, meta.getColumnListStr());
		
	}
	
	@Override
	public MetaTableTrigger newInstance() {
		return new MetaTableTrigger();
	}
}
