package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaMidFormula;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQuery;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;
import com.bokesoft.yigo.meta.bpm.process.node.MetaState;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;

public class MetaStateJSONHandler extends MetaNodeJSONHandler<MetaState> {

	@Override
	public void fromJSONImpl(MetaState meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setStatus(json.optString(JSONConstants.NODE_STATUS));
		meta.setCreateTrigger(json.optString(JSONConstants.NODE_CREATE_TRIGGER));
		meta.setFinishTrigger(json.optString(JSONConstants.NODE_FINISH_TRIGGER));
		meta.setFieldKey(json.optString(JSONConstants.NODE_FIELD_KEY));
		meta.setFieldValue(json.optString(JSONConstants.NODE_FIELD_VALUE));
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_PARTICIPATORCOLLECTION);
		if(array != null){
			MetaParticipatorCollection participatorCollection = new MetaParticipatorCollection();
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaDictionary.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaDictionary.class, jsonObject));
				}else if(MetaMidFormula.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaMidFormula.class, jsonObject));
				}else if(MetaQuery.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaQuery.class, jsonObject));
				}else if(MetaRelation.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaRelation.class, jsonObject));
				}else if(MetaExternalLink.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaExternalLink.class, jsonObject));
				}
			}
			meta.setParticipatorCollection(participatorCollection);
		}
		JSONObject o = json.optJSONObject(JSONConstants.BPM_PERM);
		if(o != null){
			MetaPerm perm = BPMJSONHandlerUtil.unbuild(MetaPerm.class, o);
			meta.setPerm(perm);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaState meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NODE_STATUS, meta.getStatus());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_CREATE_TRIGGER, meta.getCreateTrigger());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_FINISH_TRIGGER, meta.getFinishTrigger());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_FIELD_KEY, meta.getFieldKey());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_FIELD_VALUE, meta.getFieldValue());
		
		MetaParticipatorCollection participatorCollection = meta.getParticipatorCollection();
		if(participatorCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, participatorCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_PARTICIPATORCOLLECTION, array);
		}
		MetaPerm perm = meta.getPerm();
		if(perm != null){
			JSONObject o = BPMJSONHandlerUtil.build(perm, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_PERM, o);
		}
	}
	
	@Override
	public MetaState newInstance() {
		return new MetaState();
	}
}
