package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.multipleform.MetaRefForm;

public class MetaRefFormJSONHandler extends AbstractJSONHandler<MetaRefForm, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaRefForm meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setFormKey(json.optString(JSONConstants.COMMON_FORMKEY));
		meta.setObjectKey(json.optString(JSONConstants.COMMON_OBJECT_KEY));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaRefForm meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMKEY, meta.getFormKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_OBJECT_KEY, meta.getObjectKey());
		
	}
	
	@Override
	public MetaRefForm newInstance() {
		return new MetaRefForm();
	}
}
