package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaNodeGraphic;

public class MetaNodeGraphicJSONHandler extends AbstractJSONHandler<MetaNodeGraphic, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaNodeGraphic meta, JSONObject json) throws Throwable {
		meta.setX(json.optInt(JSONConstants.GRAPHIC_X));
		meta.setY(json.optInt(JSONConstants.GRAPHIC_Y));
		meta.setWidth(json.optInt(JSONConstants.GRAPHIC_WIDTH));
		meta.setHeight(json.optInt(JSONConstants.GRAPHIC_HEIGHT));
		meta.setImage(json.optString(JSONConstants.GRAPHIC_IMAGE));
		meta.setPastImage(json.optString(JSONConstants.GRAPHIC_PASTIMAGE));
		meta.setLastImage(json.optString(JSONConstants.GRAPHIC_LASTIMAGE));
		meta.setStyle(json.optString(JSONConstants.COMMON_STYLE));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaNodeGraphic meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.GRAPHIC_X, meta.getX());
		JSONHelper.writeToJSON(json, JSONConstants.GRAPHIC_Y, meta.getY());
		JSONHelper.writeToJSON(json, JSONConstants.GRAPHIC_WIDTH, meta.getWidth());
		JSONHelper.writeToJSON(json, JSONConstants.GRAPHIC_HEIGHT, meta.getHeight());
		JSONHelper.writeToJSON(json, JSONConstants.GRAPHIC_IMAGE, meta.getImage());
		JSONHelper.writeToJSON(json, JSONConstants.GRAPHIC_PASTIMAGE, meta.getPastImage());
		JSONHelper.writeToJSON(json, JSONConstants.GRAPHIC_LASTIMAGE, meta.getLastImage());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_STYLE, meta.getStyle());
		
	}
	
	@Override
	public MetaNodeGraphic newInstance() {
		return new MetaNodeGraphic();
	}
}
