package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourcePara;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourceParaCollection;

public class MetaExternalLinkJSONHandler extends AbstractJSONHandler<MetaExternalLink, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaExternalLink meta, JSONObject json) throws Throwable {
		meta.setSourceKey(json.optString(JSONConstants.PARTICIPATOR_SOURCE_KEY));
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_SOURCEPARACOLLECTION);
		if(array != null){
			MetaSourceParaCollection metaSourceParaCollection = new MetaSourceParaCollection();
			metaSourceParaCollection.addAll(0, BPMJSONHandlerUtil.unbuild(MetaSourcePara.class, array));
			meta.setSourceParaCollection(metaSourceParaCollection);
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaExternalLink meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.PARTICIPATOR_SOURCE_KEY, meta.getSourceKey());
		
		MetaSourceParaCollection metaSourceParaCollection = meta.getSourceParaCollection();
		if(metaSourceParaCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, metaSourceParaCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_SOURCEPARACOLLECTION, array);
		}
		
	}
	
	@Override
	public MetaExternalLink newInstance() {
		return new MetaExternalLink();
	}
}
