package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItem;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItemCollection;

public class MetaDataItemCollectionJSONHandler extends AbstractJSONHandler<MetaDataItemCollection, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaDataItemCollection meta, JSONObject json) throws Throwable {
		meta.setCache(json.optBoolean(JSONConstants.COMBOBOX_NEEDCACHE));
		
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if(array != null){
			meta.addAll(BPMJSONHandlerUtil.unbuild(MetaDataItem.class, array));
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDataItemCollection meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_NEEDCACHE, meta.isCache());
		
		JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
	}
	
	@Override
	public MetaDataItemCollection newInstance() {
		return new MetaDataItemCollection();
	}
}
