package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.message.MetaConsumer;

public class MetaConsumerJSONHandler extends AbstractJSONHandler<MetaConsumer, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaConsumer meta, JSONObject json) throws Throwable {
		meta.setIsReceiveMessage(json.optBoolean(JSONConstants.NODE_IS_RECEIVE_MESSAGE));
		meta.setReceiveHandleImpl(json.optString(JSONConstants.NODE_RECEIVE_HANDLE_IMPL));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaConsumer meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_IS_RECEIVE_MESSAGE, meta.isReceiveMessage());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_RECEIVE_HANDLE_IMPL, meta.getReceiveHandleImpl());
		
	}
	
	@Override
	public MetaConsumer newInstance() {
		return new MetaConsumer();
	}
	
}
