package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAutoCommitItem;

public class MetaAutoCommitItemJSONHandler extends AbstractJSONHandler<MetaAutoCommitItem, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaAutoCommitItem meta, JSONObject json) throws Throwable {
		meta.setCondition(json.optString(JSONConstants.COMMON_CONDITION));
		meta.setAuditPara(json.optString(JSONConstants.NODE_AUDIT_PARA));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaAutoCommitItem meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CONDITION, meta.getCondition());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_AUDIT_PARA, meta.getAuditPara());
		
	}
	
	@Override
	public MetaAutoCommitItem newInstance() {
		return new MetaAutoCommitItem();
	}
}
