/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.bpm;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItem;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import org.json.JSONObject;

public class MetaDataItemJSONHandler
extends AbstractJSONHandler<MetaDataItem, BPMSerializeContext> {
    @Override
    public void fromJSONImpl(MetaDataItem meta, JSONObject json) throws Throwable {
        meta.setKey(json.optString("key"));
        meta.setFromDefault(json.optBoolean("default"));
        meta.setDataType(json.optInt("dataType"));
        meta.setCache(json.optBoolean("cache"));
        String s = json.optString("content");
        if (s.length() > 0) {
            MetaBaseScript content = new MetaBaseScript("Content");
            content.setContent(s);
            meta.setContent(content);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaDataItem meta, BPMSerializeContext hook) throws Throwable {
        JSONHelper.writeToJSON((JSONObject)json, (String)"tagName", (Object)meta.getTagName());
        JSONHelper.writeToJSON((JSONObject)json, (String)"key", (Object)meta.getKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"default", (Object)meta.isFromDefault());
        JSONHelper.writeToJSON((JSONObject)json, (String)"dataType", (Object)meta.getDataType());
        JSONHelper.writeToJSON((JSONObject)json, (String)"cache", (Object)meta.isCache());
        MetaBaseScript content = meta.getContent();
        if (content != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"content", (Object)content.getContent().trim());
        }
    }

    @Override
    public MetaDataItem newInstance() {
        return new MetaDataItem();
    }
}

