/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.panel;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BasePanelJSONHandler<T extends MetaPanel>
extends BaseComponentJSONHandler<T> {
    @Override
    public void toJSONImpl(JSONObject json, T meta, DefaultSerializeContext hook) throws Throwable {
        MetaBaseScript leave;
        super.toJSONImpl(json, meta, hook);
        JSONHelper.writeToJSON((JSONObject)json, (String)"receiveFocus", (Object)false);
        JSONHelper.writeToJSON((JSONObject)json, (String)"overflowX", (Object)meta.getOverflowX());
        JSONHelper.writeToJSON((JSONObject)json, (String)"overflowY", (Object)meta.getOverflowY());
        JSONHelper.writeToJSON((JSONObject)json, (String)"backImage", (Object)meta.getBackImage());
        JSONHelper.writeToJSON((JSONObject)json, (String)"backImagePosition", (Object)meta.getBackImagePosition());
        JSONHelper.writeToJSON((JSONObject)json, (String)"isBackImageRepeatX", (Object)meta.isBackImageRepeatX());
        JSONHelper.writeToJSON((JSONObject)json, (String)"isBackImageRepeatY", (Object)meta.isBackImageRepeatY());
        JSONHelper.writeToJSON((JSONObject)json, (String)"layoutAnim", (Object)meta.getLayoutAnim());
        MetaBaseScript check = meta.getCheck();
        if (check != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"check", (Object)check.getContent().trim());
        }
        if ((leave = meta.getLeave()) != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"leave", (Object)leave.getContent().trim());
        }
        JSONArray items = new JSONArray();
        int count = meta.getComponentCount();
        for (int i = 0; i < count; ++i) {
            MetaComponent metaChild = meta.getComponent(i);
            JSONObject childJSON = UIJSONHandlerUtil.build((AbstractMetaObject)metaChild, hook);
            items.put((Object)childJSON);
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"items", (Object)items);
        MetaComponentLayout layout = meta.newLayout();
        if (layout != null) {
            JSONObject layoutJSON = UIJSONHandlerUtil.build((AbstractMetaObject)layout, hook);
            JSONHelper.writeToJSON((JSONObject)layoutJSON, (String)"type", (Object)layout.getLayoutType());
            JSONHelper.writeToJSON((JSONObject)layoutJSON, (String)"tagName", (Object)layout.getTagName());
            JSONHelper.writeToJSON((JSONObject)json, (String)"layout", (Object)layoutJSON);
        }
    }

    @Override
    public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
        MetaBaseScript script;
        super.fromJSONImpl(meta, json);
        meta.setOverflowX(json.optInt("overflowX"));
        meta.setOverflowY(json.optInt("overflowY"));
        meta.setBackImage(json.optString("backImage"));
        meta.setBackImagePosition(json.optInt("backImagePosition"));
        meta.setBackImageRepeatX(Boolean.valueOf(json.optBoolean("isBackImageRepeatX")));
        meta.setBackImageRepeatY(Boolean.valueOf(json.optBoolean("isBackImageRepeatY")));
        meta.setLayoutAnim(json.optString("layoutAnim"));
        String s = json.optString("check");
        if (s != null && !s.isEmpty()) {
            script = new MetaBaseScript("Check");
            script.setContent(s);
            meta.setCheck(script);
        }
        if ((s = json.optString("leave")) != null && !s.isEmpty()) {
            script = new MetaBaseScript("Leave");
            script.setContent(s);
            meta.setLeave(script);
        }
        JSONArray array = json.optJSONArray("items");
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            JSONObject o = array.optJSONObject(i);
            MetaComponent child = (MetaComponent)UIJSONHandlerUtil.unbuild(o);
            meta.addComponent(child);
        }
    }
}

