package com.bokesoft.yes.meta.json.setting;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.setting.MetaSessionPara;

public class MetaSessionParaJSONHandler extends AbstractJSONHandler<MetaSessionPara,SolutionSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaSessionPara meta, SolutionSerializeContext hook) throws Throwable {				
		JSONHelper.writeToJSON(json, JSONConstants.SESSION_PARAKEY, meta.getParaKey());
		JSONHelper.writeToJSON(json, JSONConstants.SESSION_ASCLUSTER, meta.isAsCluster());
		JSONHelper.writeToJSON(json, JSONConstants.SESSION_PROVIDER, meta.getProvider());		
	}

	@Override
	public MetaSessionPara newInstance() {
		return new MetaSessionPara();
	}

	@Override
	public void fromJSONImpl(MetaSessionPara meta, JSONObject json) throws Throwable {
		meta.setParaKey(json.optString(JSONConstants.SESSION_PARAKEY));
		meta.setAsCluster(json.optBoolean(JSONConstants.SESSION_ASCLUSTER));
		meta.setProvider(json.optString(JSONConstants.SESSION_PROVIDER));
	}

}
