package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.report.embed.chart.MetaReportSeries;

public class MetaReportSeriesJSONHandler extends AbstractJSONHandler<MetaReportSeries,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportSeries meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_DATAKEY, meta.getDataKey());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_SOURCE, meta.getSource());
	}

	@Override
	public MetaReportSeries newInstance() {
		return new MetaReportSeries();
	}

	@Override
	public void fromJSONImpl(MetaReportSeries meta, JSONObject json) throws Throwable {
		meta.setDataKey(json.optString(JSONConstants.REPORT_DATAKEY));
		meta.setSource(json.optString(JSONConstants.REPORT_SOURCE));
	}

}
