package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yigo.meta.report.MetaReportBorder;
import com.bokesoft.yigo.meta.report.MetaReportDisplay;
import com.bokesoft.yigo.meta.report.MetaReportFont;
import com.bokesoft.yigo.meta.report.MetaReportFormat;
import com.bokesoft.yigo.meta.report.MetaReportImageStyle;

public class MetaReportDisplayJSONHandler extends AbstractJSONHandler<MetaReportDisplay,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportDisplay meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_HALIGN, meta.getHAlign());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALIGN, meta.getVAlign());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BACKCOLOR, meta.getBackColor());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORECOLOR, meta.getForeColor());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_SHOWTYPE, meta.getShowType());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_ENCODINGTYPE, meta.getEncodingType());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_ERRORCORRECTIONLEVEL, meta.getErrorCorrectionLevel());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_MARGIN, meta.getMargin());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_ENABLEZEROSHOW, meta.isEnableZeroShow());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_ZEROSHOWSTRING, meta.getZeroShowString());
		
		MetaReportFont font = meta.getFont();
		if( font != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(font, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_FONT, o);
		}
		
		MetaReportFormat format = meta.getFormat();
		if( format != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(format, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_FORMAT, o);
		}
		
		MetaReportBorder border = meta.getBorder();
		if( border != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(border, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_BORDER, o);
		}
		
		MetaReportImageStyle imageStyle = meta.getImageStyle();
		if( imageStyle != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(imageStyle, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_IMAGESTYLE, o);
		}
		
	}

	@Override
	public MetaReportDisplay newInstance() {
		return new MetaReportDisplay();
	}

	@Override
	public void fromJSONImpl(MetaReportDisplay meta, JSONObject json) throws Throwable {
		meta.setHAlign(json.optInt(JSONConstants.COMMON_HALIGN));
		meta.setVAlign(json.optInt(JSONConstants.COMMON_VALIGN));
		meta.setBackColor(json.optString(JSONConstants.COMMON_BACKCOLOR));
		meta.setForeColor(json.optString(JSONConstants.COMMON_FORECOLOR));
		meta.setShowType(json.optString(JSONConstants.REPORT_SHOWTYPE));
		meta.setEncodingType(json.optString(JSONConstants.REPORT_ENCODINGTYPE));
		meta.setErrorCorrectionLevel(json.optString(JSONConstants.REPORT_ERRORCORRECTIONLEVEL));
		meta.setMargin(json.optInt(JSONConstants.REPORT_MARGIN));
		meta.setEnableZeroShow(json.optBoolean(JSONConstants.REPORT_ENABLEZEROSHOW));
		meta.setZeroShowString(json.optString(JSONConstants.REPORT_ZEROSHOWSTRING));
		
		JSONObject o = json.optJSONObject(JSONConstants.REPORT_FONT);
		if( o != null ) {
			MetaReportFont font = ReportJSONHandlerUtil.unbuild(MetaReportFont.class,o);
			meta.setFont(font);
		}
		
		o = json.optJSONObject(JSONConstants.REPORT_FORMAT);
		if( o != null ) {
			MetaReportFormat format = ReportJSONHandlerUtil.unbuild(MetaReportFormat.class,o);
			meta.setFormat(format);
		}
		
		o = json.optJSONObject(JSONConstants.REPORT_BORDER);
		if( o != null ) {
			MetaReportBorder border = ReportJSONHandlerUtil.unbuild(MetaReportBorder.class,o);
			meta.setBorder(border);
		}
		
		o = json.optJSONObject(JSONConstants.REPORT_IMAGESTYLE);
		if( o != null ) {
			MetaReportImageStyle imageStyle = ReportJSONHandlerUtil.unbuild(MetaReportImageStyle.class,o);
			meta.setImageStyle(imageStyle);
		}

	}

}
