package com.bokesoft.yes.meta.json.layout;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaComponentLayoutJSONHandler;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTabLayout;

public class MetaTabLayoutJSONHandler extends MetaComponentLayoutJSONHandler {
	
	@Override
	public void toJSONImpl(JSONObject json,MetaComponentLayout<? extends MetaLayoutItem> meta,
			DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaTabLayout layout = (MetaTabLayout)meta;
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_TABPOSITION, layout.getTabPosition());
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_TABMODE, layout.getTabMode());
		
		DefSize indicatorHeight = layout.getIndicatorHeight();
		if( indicatorHeight != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_INDICATORHEIGHT, indicatorHeight.toString(), "");
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_INDICATORCOLOR, layout.getIndicatorColor());
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_SHOWHEAD, layout.isShowHead());
		
		MetaBaseScript itemChanged = layout.getItemChanged();
		if( itemChanged != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_ITEMCHANGED, itemChanged.getContent().trim());
		}

		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_HOVERHEAD, layout.isHoverHead());
	}
	
	@Override
	public void fromJSONImpl(MetaComponentLayout<? extends MetaLayoutItem> meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		MetaTabLayout layout = (MetaTabLayout)meta;
		layout.setTabPosition(json.optInt(JSONConstants.TABPANEL_TABPOSITION));
		layout.setTabMode(json.optInt(JSONConstants.TABPANEL_TABMODE));
		
		String s = json.optString(JSONConstants.TABPANEL_INDICATORHEIGHT);
		if (s != null && !s.isEmpty()) {
			layout.setIndicatorHeight(DefSize.parse(s));
		}
		
		layout.setIndicatorColor(json.optString(JSONConstants.TABPANEL_INDICATORCOLOR));
		layout.setShowHead(json.optBoolean(JSONConstants.TABPANEL_SHOWHEAD));
		
		s = json.optString(JSONConstants.TABPANEL_ITEMCHANGED);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.TABPANEL_ITEMCHANGED);
			script.setContent(s);
			layout.setItemChanged(script);
		}
		
		layout.setHoverHead(json.optBoolean(JSONConstants.TABPANEL_HOVERHEAD));
	}

	@Override
	public MetaComponentLayout<? extends MetaLayoutItem> newInstance() {
		return new MetaTabLayout();
	}

}
