package com.bokesoft.yes.meta.json.layout;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaComponentLayoutJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFluidTableLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumn;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumnCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;

public class MetaFluidTableLayoutJSONHandler extends MetaComponentLayoutJSONHandler {
	
	@Override
	public void toJSONImpl(JSONObject json,MetaComponentLayout<? extends MetaLayoutItem> meta, 
			DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaFluidTableLayout layout = (MetaFluidTableLayout)meta;
		
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATCOUNT, layout.getRepeatCount());
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATGAP, layout.getRepeatGap());
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_COLUMNGAP, layout.getColumnGap());
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_ROWGAP, layout.getRowGap());
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_ROWHEIGHT, layout.getRowHeight());
		
		MetaLayoutColumnCollection columnCollection = layout.getColumnCollection();
		if( columnCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, columnCollection);
			JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_WIDTHS, array);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaComponentLayout<? extends MetaLayoutItem> meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		MetaFluidTableLayout layout = (MetaFluidTableLayout)meta;
		layout.setRepeatCount(json.optInt(JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATCOUNT));
		layout.setRepeatGap(json.optInt(JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATGAP));
		layout.setColumnGap(json.optInt(JSONConstants.FLUIDTABLELAYOUTPANEL_COLUMNGAP));
		layout.setRowGap(json.optInt(JSONConstants.FLUIDTABLELAYOUTPANEL_ROWGAP));
		layout.setRowHeight(json.optInt(JSONConstants.FLUIDTABLELAYOUTPANEL_ROWHEIGHT));
		
		JSONArray array = json.optJSONArray(JSONConstants.FLUIDTABLELAYOUTPANEL_WIDTHS);
		if( array != null ) {
			MetaLayoutColumnCollection columnCollection = new MetaLayoutColumnCollection();
			List<MetaLayoutColumn> list = UIJSONHandlerUtil.unbuild(MetaLayoutColumn.class, array);
			columnCollection.addAll(0, list);
			layout.setColumnCollection(columnCollection);
		}
	}

	@Override
	public MetaComponentLayout<? extends MetaLayoutItem> newInstance() {
		return new MetaFluidTableLayout();
	}

}
