package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.MetaVariant;

public class MetaVariantJSONHandler extends AbstractJSONHandler<MetaVariant,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaVariant meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEPENDENCY, meta.getDepended());
	}

	@Override
	public void fromJSONImpl(MetaVariant meta, JSONObject json) throws Throwable {
		meta.setDepended(json.optString(JSONConstants.COMMON_DEPENDENCY));
	}

	@Override
	public MetaVariant newInstance() {
		return new MetaVariant();
	}

}
