package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.MetaFormPara;

public class MetaFormParaJSONHandler extends AbstractJSONHandler<MetaFormPara,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaFormPara meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.FORMPARA_FORMULA, meta.getFormula());
		JSONHelper.writeToJSON(json, JSONConstants.FORMPARA_VALUE, meta.getValue());
		JSONHelper.writeToJSON(json, JSONConstants.FORMPARA_DATATYPE, meta.getDataType());
		JSONHelper.writeToJSON(json, JSONConstants.FORMPARA_SHARETOMID, meta.isShareToMid());
		JSONHelper.writeToJSON(json, JSONConstants.FORMPARA_DEPENDENCY, meta.getDependency());
	}

	@Override
	public void fromJSONImpl(MetaFormPara meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setFormula(json.optString(JSONConstants.FORMPARA_FORMULA));
		meta.setValue(json.optString(JSONConstants.FORMPARA_VALUE));
		meta.setDataType(json.optInt(JSONConstants.FORMPARA_DATATYPE));
		meta.setShareToMid(json.optBoolean(JSONConstants.FORMPARA_SHARETOMID));
		meta.setDependency(json.optString(JSONConstants.FORMPARA_DEPENDENCY));
	}

	@Override
	public MetaFormPara newInstance() {
		return new MetaFormPara();
	}

}
