package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.MetaEventHandler;

public class MetaEventHandlerJSONHandler extends MetaBaseScriptJSONHandler<MetaEventHandler,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaEventHandler meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.EVENT_HANDLER_TRIGGER, meta.getTrigger());
		JSONHelper.writeToJSON(json, JSONConstants.EVENT_HANDLER_MERGEEVENT, meta.isMergeEvent());
	}
	
	@Override
	public void fromJSONImpl(MetaEventHandler meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setTrigger(json.optInt(JSONConstants.EVENT_HANDLER_TRIGGER));
		meta.setMergeEvent(json.optBoolean(JSONConstants.EVENT_HANDLER_MERGEEVENT));
	}
}
