package com.bokesoft.yes.meta.json.form;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaRelation;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;

public class MetaDataObjectJSONHandler extends AbstractJSONHandler<MetaDataObject,ISerializeContext> {
	
	@Override
	public void fromJSONImpl(MetaDataObject meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setPrimaryType(json.optInt(JSONConstants.DATAOBJECT_PRIMARYTYPE));
		meta.setSecondaryType(json.optInt(JSONConstants.DATAOBJECT_SECONDARYTYPE));
		meta.setMainTableKey(json.optString(JSONConstants.DATAOBJECT_PRIMATYTABLEKEY));
		meta.setDisplayColumns(json.optString(JSONConstants.DATAOBJECT_DISPLAYFIELDS));
		meta.setQueryColumns(json.optString(JSONConstants.DATAOBJECT_QUERYFIELDS));
		meta.setNoPrefix(json.optString(JSONConstants.DATAOBJECT_NOPREFIX));
		meta.setCustomNoPrefix(json.optString(JSONConstants.DATAOBJECT_CUSTOMNOPREFIX));
		meta.setZeroPrefix(json.optInt(JSONConstants.DATAOBJECT_ZERO_PREFIX));
		meta.setMigrationUpdateStrategy(json.optInt(JSONConstants.DATAOBJECT_UPDATE_STRATEGY));
		meta.setRelateObjectKey(json.optString(JSONConstants.DATAOBJECT_RELATE_OBJECT_KEY));
		meta.setVersion(json.optInt(JSONConstants.DATAOBJECT_VERSION));
		meta.setProjectKey(json.optString(JSONConstants.DATAOBJECT_PROJECTKEY));
		meta.setMaintainSchema(json.optBoolean(JSONConstants.DATAOBJECT_MAINTAINSCHEMA));
		meta.setExtend(json.optString(JSONConstants.FORM_EXTEND));
		JSONArray array = json.optJSONArray(JSONConstants.DATAOBJECT_TABLECOLLECTION);
		if( array != null ) {
			MetaTableCollection tableCollection = new MetaTableCollection();
			List<MetaTable> list = UIJSONHandlerUtil.unbuild(MetaTable.class, array);
			tableCollection.addAll(list);
			meta.setTableCollection(tableCollection);
			meta.setMainTable(tableCollection.get(meta.getMainTableKey()));
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.DATAOBJECT_RELATIONS);
		if( o != null ) {
			MetaRelation relation = UIJSONHandlerUtil.unbuild(MetaRelation.class, o);
			meta.setRelation(relation);
		}
	} 

	@Override
	public void toJSONImpl(JSONObject json, MetaDataObject meta, ISerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, hook.getDataObjectString(meta.getKey(), meta.getCaption()));
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_PRIMARYTYPE, meta.getPrimaryType());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_SECONDARYTYPE, meta.getSecondaryType());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_PRIMATYTABLEKEY, meta.getMainTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_MAINTABLEKEY, meta.getMainTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_DISPLAYFIELDS, meta.getDisplayColumnsStr());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_QUERYFIELDS, meta.getQueryColumnsStr());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_NOPREFIX, meta.getNoPrefix());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_CUSTOMNOPREFIX, meta.getCustomNoPrefix());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_ZERO_PREFIX, meta.getZeroPrefix());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_UPDATE_STRATEGY, meta.getMigrationUpdateStrategy());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_RELATE_OBJECT_KEY, meta.getRelateObjectKey());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_VERSION, meta.getVersion());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_PROJECTKEY, meta.getProjectKey());
		JSONHelper.writeToJSON(json, JSONConstants.DATAOBJECT_MAINTAINSCHEMA, meta.isMaintainSchema());
		
		MetaTableCollection tableCollection = meta.getTableCollection();
		if( tableCollection != null ) {
			JSONArray tables = new JSONArray();
			for( MetaTable metaTable : tableCollection ) {
				String tableKey = metaTable.getKey();
				JSONObject table = UIJSONHandlerUtil.build(metaTable, hook);
				JSONArray columns = table.optJSONArray(JSONConstants.TABLE_COLUMNS);
				for( int i = 0,size = columns.length();i < size;i++ ) {
					JSONObject column = columns.optJSONObject(i);
					String columnKey = column.getString(JSONConstants.COMMON_KEY);
					MetaColumn metaColumn = metaTable.get(columnKey);
					String caption = hook.getDataObjectString(meta.getKey(), tableKey, columnKey, metaColumn.getCaption());
					JSONHelper.writeToJSON(column, JSONConstants.COMMON_CAPTION, caption);
				}
				tables.put(table);
			}
			json.put(JSONConstants.DATAOBJECT_TABLECOLLECTION, tables);
		}
		
		MetaRelation relation = meta.getRelation();
		if( relation != null ) {
			JSONObject o = UIJSONHandlerUtil.build(relation, hook);
			json.put(JSONConstants.DATAOBJECT_RELATIONS, o);
		}
		
	}

	@Override
	public MetaDataObject newInstance() {
		return new MetaDataObject();
	}


}
