package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaLabelProperties;

public class MetaLabelPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaLabelProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaLabelProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.LABEL_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.LABEL_SINGLELINE, meta.isSingleLine());
		JSONHelper.writeToJSON(json, JSONConstants.LABEL_LINEBREKTYPE, meta.getLineBreakMode());
		JSONHelper.writeToJSON(json, JSONConstants.LABEL_MAXLINES, meta.getMaxLines());
		JSONHelper.writeToJSON(json, JSONConstants.LABEL_EXPANDCAPTION, meta.getExpandCaption());
	}

	@Override
	public void fromJSONImpl(MetaLabelProperties meta, JSONObject json) throws Throwable {
		meta.setIcon(json.optString(JSONConstants.LABEL_ICON));
		meta.setSingleLine(json.optBoolean(JSONConstants.LABEL_SINGLELINE));
		meta.setLineBreakMode(json.optInt(JSONConstants.LABEL_LINEBREKTYPE));
		meta.setMaxLines(json.optInt(JSONConstants.LABEL_MAXLINES));
		meta.setExpandCaption(json.optString(JSONConstants.LABEL_EXPANDCAPTION));
	}

	@Override
	public MetaLabelProperties newInstance() {
		return new MetaLabelProperties();
	}

}
