package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDateRangePickerProperties;

public class MetaDateRangePickerPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaDateRangePickerProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDateRangePickerProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_FORMATSTR, meta.getDateFormat());
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_MINTIME, meta.getMinTime());
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_MAXTIME, meta.getMaxTime());
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_LINKSTYLE, meta.getLinkStyle());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, meta.getPromptText());
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_ISONLYDATE, meta.isOnlyDate());
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_EDITTYPE, meta.getEditType());
	}

	@Override
	public void fromJSONImpl(MetaDateRangePickerProperties meta, JSONObject json) throws Throwable {
		meta.setDateFormat(json.optString(JSONConstants.DATEPICKER_FORMATSTR));
		meta.setMinTime(json.optString(JSONConstants.DATERANGEPICKER_MINTIME));
		meta.setMaxTime(json.optString(JSONConstants.DATERANGEPICKER_MAXTIME));
		meta.setLinkStyle(json.optString(JSONConstants.DATERANGEPICKER_LINKSTYLE));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		meta.setOnlyDate(json.optBoolean(JSONConstants.DATERANGEPICKER_ISONLYDATE));
		meta.setEditType(json.optInt(JSONConstants.DATERANGEPICKER_EDITTYPE));
	}

	@Override
	public MetaDateRangePickerProperties newInstance() {
		return new MetaDateRangePickerProperties();
	}
}

