package com.bokesoft.yes.meta.json.com.listView;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRotator;

public class MetaRotatorJSONHandler extends MetaListViewJSONHandler<MetaRotator> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaRotator meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.ROTATER_INTERVALTIME, meta.getIntervalTime());
		JSONHelper.writeToJSON(json, JSONConstants.GALLERY_REPEAT, meta.isRepeat());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATER_INDICATOR, meta.isIndicator());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATER_INDICATORLOCATION, meta.getIndicatorLocation());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATER_PAGINATION, meta.isPagination());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATER_ANIMTIME, meta.getAnimTime());
	}
	
	@Override
	public void fromJSONImpl(MetaRotator meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setIntervalTime(json.optDouble(JSONConstants.ROTATER_INTERVALTIME));
		meta.setRepeat(json.optBoolean(JSONConstants.GALLERY_REPEAT));
		meta.setIndicator(json.optBoolean(JSONConstants.ROTATER_INDICATOR));
		meta.setIndicatorLocation(json.optInt(JSONConstants.ROTATER_INDICATORLOCATION));
		meta.setPagination(json.optBoolean(JSONConstants.ROTATER_PAGINATION));
		meta.setAnimTime(json.optDouble(JSONConstants.ROTATER_ANIMTIME));
	}
	
	@Override
	public MetaRotator newInstance() {
		return new MetaRotator();
	}
}
