package com.bokesoft.yes.meta.json.com.listView;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaGallery;

public class MetaGalleryJSONHandler extends MetaListViewJSONHandler<MetaGallery> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaGallery meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.GALLERY_REPEAT, meta.isRepeat());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATORLIST_CELLGAP, meta.getCellGap());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATER_INDICATOR, meta.isIndicator());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATER_INDICATORLOCATION, meta.getIndicatorLocation());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATER_PAGINATION, meta.isPagination());
		JSONHelper.writeToJSON(json, JSONConstants.GALLERY_DISPLAYRATIO, meta.getDisplayRatio()+"");
	}
	
	@Override
	public void fromJSONImpl(MetaGallery meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setRepeat(json.optBoolean(JSONConstants.GALLERY_REPEAT));
		meta.setCellGap(json.optInt(JSONConstants.ROTATORLIST_CELLGAP));
		meta.setIndicator(json.optBoolean(JSONConstants.ROTATER_INDICATOR));
		meta.setIndicatorLocation(json.optInt(JSONConstants.ROTATER_INDICATORLOCATION));
		meta.setPagination(json.optBoolean(JSONConstants.ROTATER_PAGINATION));
		meta.setDisplayRatio(Float.parseFloat(json.optString(JSONConstants.GALLERY_DISPLAYRATIO)));
	}
	
	@Override
	public MetaGallery newInstance() {
		return new MetaGallery();
	}
	
}
