package com.bokesoft.yes.meta.json.com.grid;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.struct.report.MultiDimValue;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.meta.form.MetaUICheckRule;
import com.bokesoft.yigo.meta.form.MetaUICheckRuleCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowExpand;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowTree;

public class MetaGridRowJSONHandler extends AbstractJSONHandler<MetaGridRow,DefaultSerializeContext>{
	
	@Override
	public void fromJSONImpl(MetaGridRow meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setRowType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setRowHeight(json.optInt(JSONConstants.GRID_ROWHEIGHT));
		meta.setGroupHead(json.optBoolean(JSONConstants.GRID_ISGROUPHEAD));
		meta.setGroupTail(json.optBoolean(JSONConstants.GRID_ISGROUPTAIL));
		meta.setAreaIndex(json.optInt(JSONConstants.GRID_AREAINDEX));
		meta.setDetailHead(json.optBoolean(JSONConstants.GRID_ISDETAILHEAD));
		meta.setDetailTail(json.optBoolean(JSONConstants.GRID_ISDETAILTAIL));
		meta.setDetailIndex(json.optInt(JSONConstants.GRID_DETAILINDEX));
		meta.setLinkType(json.optInt(JSONConstants.GRID_LINKTYPE));
		meta.setTarget(json.optString(JSONConstants.GRID_TARGET));
		meta.setSource(json.optString(JSONConstants.GRID_SOURCE));
		meta.setBackColor(json.optString(JSONConstants.COMMON_BACKCOLOR));
		meta.setDefaultLayer(json.optInt(JSONConstants.GRID_DEFAULTLAYER));
		
		meta.setTableKey(json.optString(JSONConstants.COMMON_TABLEKEY));
		meta.setGroupKey(json.optString(JSONConstants.GRID_GROUPKEY));
		meta.setVisible(json.optString(JSONConstants.COMMON_VISIBLE));
		meta.setFrozen(json.optBoolean(JSONConstants.GRID_FROZEN));
		meta.setRefKey(json.optString(JSONConstants.GRID_REFKEY));
		meta.setDetailKey(json.optString(JSONConstants.GRID_DETAILKEY));
		meta.setRecycleMode(json.optInt(JSONConstants.GRID_RECYCLEMODE));
		meta.setAreaHead(json.optBoolean(JSONConstants.GRID_ISAREALHEAD));
		meta.setAreaTail(json.optBoolean(JSONConstants.GRID_ISAREALTAIL));
		meta.setAreaExpand(json.optBoolean(JSONConstants.GRID_AREAEXPAND));
		
		JSONObject o = json.optJSONObject(JSONConstants.GRID_ROWEXPAND);
		if( o != null ) {
			MetaRowExpand rowExpand = UIJSONHandlerUtil.unbuild(MetaRowExpand.class, o);
			meta.setRowExpand(rowExpand);
		}
		
		o = json.optJSONObject(JSONConstants.GRID_ROWTREE);
		if( o != null ) {
			MetaRowTree rowTree = UIJSONHandlerUtil.unbuild(MetaRowTree.class, o);
			meta.setRowTree(rowTree);
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.GRID_DIMVALUE);
		if( array != null ) {
			MultiDimValue dimValue = new MultiDimValue();
			dimValue.fromJSONArray(array);
			meta.setDimValue(dimValue);
		}
		
		array = json.optJSONArray(JSONConstants.GRID_CELLS);
		if( array != null ) {
			List<MetaGridCell> list = UIJSONHandlerUtil.unbuild(MetaGridCell.class, array);
			meta.addAll(0, list);
		}
		
		array = json.optJSONArray(JSONConstants.GRID_CHECKRULES);
		if( array != null ) {
			List<MetaUICheckRule> list = UIJSONHandlerUtil.unbuild(MetaUICheckRule.class, array);
			MetaUICheckRuleCollection collection = new MetaUICheckRuleCollection();
			collection.addAll(0, list);
			meta.setCheckRuleCollection(collection);
		}
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaGridRow meta, DefaultSerializeContext hook)
			throws Throwable {
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_OBJECTTYPE, meta.getObjectType());
		
		//str(为了做兼容)
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWTYPE, RowType.toString(meta.getRowType()));
		//int
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getRowType());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLE, meta.getVisible());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BACKCOLOR, meta.getBackColor());
		
		JSONHelper.writeToJSON(json, JSONConstants.GRID_DEFAULTLAYER, meta.getDefaultLayer());		 
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWHEIGHT, meta.getRowHeight());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISGROUPHEAD, meta.isGroupHead());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISGROUPTAIL, meta.isGroupTail());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISDETAILHEAD, meta.isDetailHead());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISDETAILTAIL, meta.isDetailTail());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_AREAINDEX, meta.getAreaIndex());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISAREALHEAD, meta.isAreaHead());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ISAREALTAIL, meta.isAreaTail());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_DETAILINDEX, meta.getDetailIndex());
		
		JSONHelper.writeToJSON(json, JSONConstants.GRID_LINKTYPE, meta.getLinkType());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TARGET, meta.getTarget());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SOURCE, meta.getSource());
		
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TARGETFIELDS, meta.getTargetFields());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SOURCEFIELDS, meta.getSourceFields());
		
		JSONHelper.writeToJSON(json, JSONConstants.GRID_GROUPKEY, meta.getGroupKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_FROZEN, meta.isFrozen());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_REFKEY, meta.getRefKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_KEYWORDS, meta.getKeywords());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_AREAEXPAND, meta.isAreaExpand());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_DETAILKEY, meta.getDetailKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_RECYCLEMODE, meta.getRecycleMode());
		
		MetaRowExpand rowExpand = meta.getRowExpand(); // 行拓展
		if( rowExpand != null ) {
			JSONObject o = UIJSONHandlerUtil.build(rowExpand,hook);
			JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWEXPAND, o);   
		}
		MetaRowTree rowTree = meta.getRowTree(); // 树
		if( rowTree != null ) {
			JSONObject o = UIJSONHandlerUtil.build(rowTree,hook);
			JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWTREE, o);
		}
		MultiDimValue dimValue = meta.getDimValue(); // 维度数据
		if( dimValue != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.GRID_DIMVALUE, dimValue.toJSONArray());
		}
		
		JSONArray cells = UIJSONHandlerUtil.buildNoKeyWithKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.GRID_CELLS, cells);
		JSONArray cellKeys = new JSONArray();
		for (MetaGridCell cell : meta) {
			cellKeys.put(cell.getKey());
		}
		JSONHelper.writeToJSON(json, JSONConstants.GRID_CELLKEYS, cellKeys);

		MetaUICheckRuleCollection checkRuleCollection = meta.getCheckRuleCollection();
		if( checkRuleCollection != null ) {
			JSONArray rules = UIJSONHandlerUtil.buildNoKeyCollection(hook, checkRuleCollection);
			JSONHelper.writeToJSON(json, JSONConstants.GRID_CHECKRULES, rules);
		} 
	}

	@Override
	public MetaGridRow newInstance() {
		return new MetaGridRow();
	}

}
