package com.bokesoft.yes.meta.json.com.grid;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilterValue;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridFilter;

public class MetaGridFilterJSONHandler extends AbstractJSONHandler<MetaGridFilter,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaGridFilter meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.GRID_FILTEROPTSIGN, meta.getOptSign());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_FILTEDEPENDENCY, meta.getFilterDependency());
		
		JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.GRID_FILTEVALUES, array);
	}

	@Override
	public void fromJSONImpl(MetaGridFilter meta, JSONObject json) throws Throwable {
		meta.setOptSign(json.optInt(JSONConstants.GRID_FILTEROPTSIGN));
		meta.setFilterDependency(json.optString(JSONConstants.GRID_FILTEDEPENDENCY));
		
		JSONArray array = json.optJSONArray(JSONConstants.GRID_FILTEVALUES);
		if( array != null ) {
			List<MetaFilterValue> list = UIJSONHandlerUtil.unbuild(MetaFilterValue.class, array);
			meta.addAll(0, list);
		}
	}

	@Override
	public MetaGridFilter newInstance() {
		return new MetaGridFilter();
	}

}
