package com.bokesoft.yes.meta.json.com.grid;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaBaseScriptJSONHandler;
import com.bokesoft.yigo.meta.form.component.grid.MetaExtOpt;

public class MetaExtOptJSONHandler extends MetaBaseScriptJSONHandler<MetaExtOpt,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaExtOpt meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon());
	}
	
	@Override
	public void fromJSONImpl(MetaExtOpt meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setIcon(json.optString(JSONConstants.COMMON_ICON));
	}
	
	@Override
	public MetaExtOpt newInstance() {
		return new MetaExtOpt();
	}
}
