package com.bokesoft.yes.meta.json.com.comp;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationItem;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationItemCollection;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationList;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationListRow;

public class MetaNavigationListJSONHandler extends BaseComponentJSONHandler<MetaNavigationList>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaNavigationList meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_STYLE, meta.getStyle());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_SOURCE, meta.getSource());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_ENTRYPATH, meta.getEntryPath());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_ALLENTRYFILTER, meta.isAllEntryFilter());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_COLUMNCOUNT, meta.getColumnCount());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_IMAGESCALETYPE, meta.getImageScaleType());
		
		MetaNavigationItemCollection items = meta.getItemCollection();
		if( items != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, items);
			JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_ITEMS, array);
		}
		
		MetaNavigationListRow row = meta.getListRow();
		if( row != null ) {
			JSONObject o = UIJSONHandlerUtil.build(row,hook);
			JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONLIST_LISTROW, o);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaNavigationList meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setStyle(json.optInt(JSONConstants.NAVIGATIONLIST_STYLE));
		meta.setSource(json.optInt(JSONConstants.NAVIGATIONLIST_SOURCE));
		meta.setEntryPath(json.optString(JSONConstants.NAVIGATIONLIST_ENTRYPATH));
		meta.setAllEntryFilter(json.optBoolean(JSONConstants.NAVIGATIONLIST_ALLENTRYFILTER));
		meta.setColumnCount(json.optInt(JSONConstants.NAVIGATIONLIST_COLUMNCOUNT));
		meta.setImageScaleType(json.optInt(JSONConstants.NAVIGATIONLIST_IMAGESCALETYPE));
		
		JSONArray array = json.optJSONArray(JSONConstants.NAVIGATIONLIST_ITEMS);
		if( array != null ) {
			MetaNavigationItemCollection items = new MetaNavigationItemCollection();
			List<MetaNavigationItem> list = UIJSONHandlerUtil.unbuild(MetaNavigationItem.class, array);
			items.addAll(list);
			meta.setItemCollection(items);
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.NAVIGATIONLIST_LISTROW);
		if( o != null ) {
			MetaNavigationListRow listRow = UIJSONHandlerUtil.unbuild(MetaNavigationListRow.class, o);
			meta.setListRow(listRow);
		}
	}

	@Override
	public MetaNavigationList newInstance() {
		return new MetaNavigationList();
	}
	
}
