package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;

public class MetaDefaultItemJSONHandler extends AbstractJSONHandler<MetaDefaultItem,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaDefaultItem meta, DefaultSerializeContext hook)
			throws Throwable {
		//toJSON时需要控件的key做i18n翻译，因此这里不处理，交给控件处理
	}

	@Override
	public void fromJSONImpl(MetaDefaultItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setValue(json.optString(JSONConstants.COMMON_VALUE));
	}

	@Override
	public MetaDefaultItem newInstance() {
		return new MetaDefaultItem();
	}
}
