package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;

public class MetaDataBindingJSONHandler extends AbstractJSONHandler<MetaDataBinding,DefaultSerializeContext> {
	
	@Override
	public void fromJSONImpl(MetaDataBinding meta, JSONObject json) throws Throwable {
		meta.setTableKey(json.optString(JSONConstants.DATABINDING_TABLEKEY));
		meta.setColumnKey(json.optString(JSONConstants.DATABINDING_COLUMNKEY));
		meta.setRequired(json.optBoolean(JSONConstants.DATABINDING_REQUIRED));
		meta.setValueChanging(json.optString(JSONConstants.DATABINDING_VALUECHANGING));
		meta.setValueChanged(json.optString(JSONConstants.DATABINDING_VALUECHANGED));
		meta.setValueChangeAction(json.optString(JSONConstants.DATABINDING_VALUECHANGEACTION));
		meta.setDefaultValue(json.optString(JSONConstants.DATABINDING_DEFAULTVALUE));
		meta.setDefaultFormulaValue(json.optString(JSONConstants.DATABINDING_DEFAULTFORMULAVALUE));
		meta.setValueDependency(json.optString(JSONConstants.DATABINDING_VALUEDEPENDENCY));
		meta.setCheckRule(json.optString(JSONConstants.DATABINDING_CHECKRULE));
		meta.setCheckDependency(json.optString(JSONConstants.DATABINDING_CHECKDEPENDENCY));
		meta.setErrorInfo(json.optString(JSONConstants.CHECKRULE_ERRORINFO));
		meta.setErrorStringID(json.optString(JSONConstants.CHECKRULE_ERRORSTRINGID));
		meta.setRequiredIcon(json.optString(JSONConstants.DATABINDING_REQUIRED_ICON));
		meta.setCheckRulePassIcon(json.optString(JSONConstants.DATABINDING_CHECKRULE_PASS_ICON));
		meta.setCheckRuleErrorIcon(json.optString(JSONConstants.DATABINDING_CHECKRULE_ERROR_ICON));
		
		String s = json.optString(JSONConstants.DATABINDING_VALIDATION);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_ValueValidation);
			script.setContent(s);
			meta.setValueValidation(script);
		}
		
		s = json.optString(JSONConstants.DATABINDING_VALUECHANGED);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_ValueChanged);
			script.setContent(s);
			meta.setValueChangedNode(script);
		}
		
		s = json.optString(JSONConstants.DATABINDING_VALUECHANGEACTION);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_ValueChangeAction);
			script.setContent(s);
			meta.setValueChangeActionNode(script);
		}
		
		s = json.optString(JSONConstants.DATABINDING_VALUECHANGING);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_ValueChanging);
			script.setContent(s);
			meta.setValueChangingNode(script);
		}
		
		s = json.optString(JSONConstants.DATABINDING_TEXTCHANGED);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_TextChanged);
			script.setContent(s);
			meta.setTextChangedNode(script);
		}
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaDataBinding meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_COLUMNKEY, meta.getColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_REQUIRED, meta.isRequired());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_VALUECHANGING, meta.getValueChanging());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_VALUECHANGED, meta.getValueChanged());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_VALUECHANGEACTION, meta.getValueChangeAction(), "");
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_DEFAULTVALUE,meta.getDefaultValue());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_VALUEDEPENDENCY, meta.getValueDependency());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_CHECKRULE, meta.getCheckRule());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_CHECKDEPENDENCY, meta.getCheckDependency());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKRULE_ERRORINFO, meta.getErrorInfo());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKRULE_ERRORSTRINGID, meta.getErrorStringID());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_REQUIRED_ICON, meta.getRequiredIcon());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_CHECKRULE_PASS_ICON, meta.getCheckRulePassIcon());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_CHECKRULE_ERROR_ICON, meta.getCheckRuleErrorIcon());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_EXTENDJSON, new JSONObject(meta.getExtendJson()));

		MetaBaseScript valueValidation = meta.getValueValidation();
		if(valueValidation != null) {
			JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_VALIDATION, valueValidation.getContent().trim());
		}
		MetaBaseScript valueChanged = meta.getValueChangedNode();
		if(valueChanged != null) {
			JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_VALUECHANGED, valueChanged.getContent().trim());
		}
		
		MetaBaseScript valueChangeActionNode = meta.getValueChangeActionNode();
		if (valueChangeActionNode != null) {
			JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_VALUECHANGEACTION, valueChangeActionNode.getContent().trim(), "");
		}

		MetaBaseScript valueChanging = meta.getValueChangingNode();
		if(valueChanging != null) {
			JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_VALUECHANGING, valueChanging.getContent().trim());
		}
		MetaBaseScript textChanged = meta.getTextChangedNode();
		if(textChanged != null) {
			JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_TEXTCHANGED, textChanged.getContent().trim());
		}
	}

	@Override
	public MetaDataBinding newInstance() {
		return new MetaDataBinding();
	}
}
