package com.bokesoft.yes.meta.json.com.comp;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.common.MetaCustomCondition;
import com.bokesoft.yigo.meta.common.MetaCustomConditionPara;

public class MetaCustomConditionJSONHandler extends AbstractJSONHandler<MetaCustomCondition,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaCustomCondition meta, DefaultSerializeContext hook)
			throws Throwable {
		
		JSONHelper.writeToJSON(json, JSONConstants.CUSTOM_CONDITION_CONDITION, meta.getCondition());
		JSONHelper.writeToJSON(json, JSONConstants.CUSTOM_CONDITION_FILTER, meta.getFilter());
		
		JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
	}
	
	@Override
	public void fromJSONImpl(MetaCustomCondition meta, JSONObject json) throws Throwable {
		meta.setCondition(json.optString(JSONConstants.CUSTOM_CONDITION_CONDITION));
		meta.setFilter(json.optString(JSONConstants.CUSTOM_CONDITION_FILTER));
		
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		List<MetaCustomConditionPara> list = UIJSONHandlerUtil.unbuild(MetaCustomConditionPara.class, array);
		
		meta.addAll(0, list);
	}

	@Override
	public MetaCustomCondition newInstance() {
		return new MetaCustomCondition();
	}

}
