package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.container.MetaContainer;
import com.bokesoft.yigo.meta.form.component.control.MetaTabGroup;

public class MetaContainerJSONHandler extends BaseComponentJSONHandler<MetaContainer>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaContainer meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.CONTAINER_STYLE, meta.getStyle());
		JSONHelper.writeToJSON(json, JSONConstants.CONTAINER_DEFAULT, meta.isDefault());
		JSONHelper.writeToJSON(json, JSONConstants.CONTAINER_MERGEOPERATION, meta.isMergeOperation());
		JSONHelper.writeToJSON(json, JSONConstants.CONTAINER_DEFAULTFORMKEY, meta.getDefaultFormKey());
		JSONHelper.writeToJSON(json, JSONConstants.CONTAINER_FORMULAFORMKEY, meta.getFormulaFormKey());

		MetaTabGroup tabGroup = meta.getTabGroup();
		if ( tabGroup != null ) {
			JSONObject o = UIJSONHandlerUtil.build(tabGroup,hook);
			json.put(JSONConstants.CONTAINER_TABGROUP, o);
		}
	}

	@Override
	public void fromJSONImpl(MetaContainer meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setStyle(json.optInt(JSONConstants.CONTAINER_STYLE));
		meta.setDefault(json.optBoolean(JSONConstants.CONTAINER_DEFAULT));
		meta.setMergeOperation(json.optBoolean(JSONConstants.CONTAINER_MERGEOPERATION));
		meta.setDefaultFormKey(json.optString(JSONConstants.CONTAINER_DEFAULTFORMKEY));
		meta.setFormulaFormKey(json.optString(JSONConstants.CONTAINER_FORMULAFORMKEY));
		
		JSONObject o = json.optJSONObject(JSONConstants.CONTAINER_TABGROUP);
		if( o != null ) {
			MetaTabGroup tabGroup = UIJSONHandlerUtil.unbuild(MetaTabGroup.class, o);
			meta.setTabGroup(tabGroup);
		}
	}

	@Override
	public MetaContainer newInstance() {
		return new MetaContainer();
	}
	
}
