package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.timer.period.WorkDay;

public class WorkDayJSONHandler extends AbstractJSONHandler<WorkDay, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(WorkDay meta, JSONObject json) throws Throwable {
		meta.setDayCount(json.optInt(JSONConstants.TIMER_DAY_COUNT));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, WorkDay meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_DAY_COUNT, meta.getDayCount());
		
	}
	
	@Override
	public WorkDay newInstance() {
		return new WorkDay();
	}
}
