package com.bokesoft.yes.meta.json;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yigo.meta.bpm.AbstractBPMElement;

public abstract class AbstractBPMElementJSONHandler<T extends AbstractBPMElement> extends AbstractJSONHandler<T, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setID(json.optInt(JSONConstants.COMMON_ID));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, T meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ID, meta.getID());
	}
	
}
