/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.com.properties;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.com.properties.BasePropertiesJSONHandler;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMultiStateButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStateItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStateItemCollection;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaMultiStateButtonPropertiesJSONHandler
extends BasePropertiesJSONHandler<MetaMultiStateButtonProperties> {
    @Override
    public void toJSONImpl(JSONObject json, MetaMultiStateButtonProperties meta, DefaultSerializeContext hook, String key) throws Throwable {
        MetaStateItemCollection collection;
        JSONHelper.writeToJSON((JSONObject)json, (String)"iconLocation", (Object)meta.getIconLocation());
        MetaBaseScript onClick = meta.getOnClick();
        if (onClick != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"onClick", (Object)onClick.getContent().trim());
        }
        if ((collection = meta.getItemCollection()) != null) {
            JSONArray array = this.buildItems(key, collection, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"stateItem", (Object)array);
        }
    }

    @Override
    public void fromJSONImpl(MetaMultiStateButtonProperties meta, JSONObject json) throws Throwable {
        JSONArray array;
        meta.setIconLocation(json.optInt("iconLocation"));
        String s = json.optString("onClick");
        if (s != null && !s.isEmpty()) {
            MetaBaseScript script = new MetaBaseScript("OnClick");
            script.setContent(s);
            meta.setOnClick(script);
        }
        if ((array = json.optJSONArray("stateItem")) != null) {
            MetaStateItemCollection collection = this.unbuild(array);
            meta.setItemCollection(collection);
        }
    }

    @Override
    public MetaMultiStateButtonProperties newInstance() {
        return new MetaMultiStateButtonProperties();
    }

    private JSONArray buildItems(String key, MetaStateItemCollection collection, DefaultSerializeContext hook) throws Throwable {
        JSONArray array = new JSONArray();
        Iterator it = collection.iterator();
        MetaStateItem item = null;
        while (it.hasNext()) {
            item = (MetaStateItem)it.next();
            JSONObject o = new JSONObject();
            JSONHelper.writeToJSON((JSONObject)o, (String)"key", (Object)item.getKey());
            String text = hook.getString("Items", key, "Item-" + item.getKey(), item.getText());
            JSONHelper.writeToJSON((JSONObject)o, (String)"text", (Object)text);
            JSONHelper.writeToJSON((JSONObject)o, (String)"value", (Object)item.getValue());
            JSONHelper.writeToJSON((JSONObject)o, (String)"icon", (Object)item.getIcon());
            array.put((Object)o);
        }
        return array;
    }

    private MetaStateItemCollection unbuild(JSONArray array) {
        MetaStateItemCollection collection = new MetaStateItemCollection();
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            JSONObject o = array.optJSONObject(i);
            MetaStateItem item = new MetaStateItem();
            item.setKey(o.optString("key"));
            item.setText(o.optString("text"));
            item.setValue(o.optString("value"));
            item.setIcon(o.optString("icon"));
            collection.add((AbstractMetaObject)item);
        }
        return collection;
    }
}

