/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.automap.excel.template.action.container;

import com.bokesoft.yes.automap.excel.template.action.container.AbstractContainerMapAction;
import com.bokesoft.yes.automap.excel.template.out.column.ListViewColumnData;
import com.bokesoft.yes.automap.excel.template.out.column.ListViewColumnDataBuilder;
import com.bokesoft.yes.automap.excel.traveral.out.AutoMapContext;
import com.bokesoft.yes.automap.excel.traveral.out.OutContainer;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRows;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelSheet;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;

public class MapListViewAction
extends AbstractContainerMapAction<MetaListView> {
    @Override
    public void doAction(MetaListView metaListView, MetaExcelSheet metaExcelSheet, AutoMapContext<MetaExcelSheet> autoMapContext) {
        metaExcelSheet = metaExcelSheet.getRows();
        ListViewColumnDataBuilder listViewColumnDataBuilder = new ListViewColumnDataBuilder(metaListView.getKey(), metaListView.getColumnCollection(), autoMapContext);
        Object object = listViewColumnDataBuilder.build();
        int n = listViewColumnDataBuilder.getRowCount();
        int n2 = listViewColumnDataBuilder.getLeafCount();
        OutContainer<MetaExcelSheet> outContainer = this.installNewContainer(metaListView.getKey(), 2, n2, autoMapContext);
        object = object.iterator();
        while (object.hasNext()) {
            ListViewColumnData listViewColumnData = (ListViewColumnData)object.next();
            this.traversalColumnAction(metaListView, listViewColumnData, outContainer, autoMapContext);
        }
        object = this.ensureExcelRow((MetaExcelRows)metaExcelSheet, outContainer.getStartRowPos() + n);
        this.initExcelRow((MetaExcelRow)object, metaListView, autoMapContext);
    }

    private void traversalColumnAction(MetaListView metaListView, ListViewColumnData listViewColumnData, OutContainer<MetaExcelSheet> outContainer, AutoMapContext<MetaExcelSheet> autoMapContext) {
        if (!autoMapContext.isNeedAutoMapField(metaListView.getKey(), listViewColumnData.getKey())) {
            return;
        }
        metaListView = new MetaExcelCell();
        MetaExcelRows metaExcelRows = ((MetaExcelSheet)outContainer.getMeta()).getRows();
        int n = outContainer.getStartRowPos();
        MetaExcelRow metaExcelRow = this.ensureExcelRow(metaExcelRows, n);
        metaExcelRow.setType(2);
        metaExcelRow.add((AbstractMetaObject)metaListView);
        metaListView.setCellIndex(autoMapContext.getStartColPos() + listViewColumnData.getCol());
        metaListView.setMergedColumnSpan(listViewColumnData.getColSpan());
        metaListView.setMergedRowSpan(listViewColumnData.getRowSpan());
        metaListView.setDefinition(listViewColumnData.getCaption());
        metaListView.setSourceType(2);
    }

    private void initExcelRow(MetaExcelRow metaExcelRow, MetaListView metaListView, AutoMapContext<MetaExcelSheet> autoMapContext) {
        metaExcelRow.setTableKey(metaListView.getTableKey());
        metaExcelRow.setType(3);
        int n = 0;
        for (MetaListViewColumn metaListViewColumn : metaListView.getColumnCollection()) {
            if (!autoMapContext.isNeedAutoMapField(metaListView.getKey(), metaListViewColumn.getKey())) continue;
            MetaExcelCell metaExcelCell = new MetaExcelCell();
            metaExcelRow.add((AbstractMetaObject)metaExcelCell);
            this.initExcelCellByColumn(metaExcelCell, metaListViewColumn, autoMapContext.getStartColPos() + n, autoMapContext);
            ++n;
        }
    }

    private void initExcelCellByColumn(MetaExcelCell metaExcelCell, MetaListViewColumn object, int n, AutoMapContext<MetaExcelSheet> autoMapContext) {
        if (object.hasDataBinding().booleanValue() || !StringUtil.isBlankOrNull((String)object.getCaption())) {
            metaExcelCell.setCellIndex(n);
            if (!StringUtil.isBlankOrNull((String)object.getDataColumnKey())) {
                metaExcelCell.setSourceType(0);
                metaExcelCell.setDefinition(object.getDataColumnKey());
            } else if (!StringUtil.isBlankOrNull((String)object.getDefaultFormulaValue())) {
                metaExcelCell.setSourceType(1);
                metaExcelCell.setDefinition(object.getDefaultFormulaValue());
            } else if (!StringUtil.isBlankOrNull((String)object.getDefaultValue())) {
                metaExcelCell.setSourceType(2);
                metaExcelCell.setDefinition(object.getDefaultValue());
            } else if (!StringUtil.isBlankOrNull((String)object.getCaption())) {
                metaExcelCell.setSourceType(2);
                metaExcelCell.setDefinition(object.getCaption());
            }
            MetaComponent metaComponent = MetaComponentFactory.getInstance().newComponent(ControlType.toString((int)object.getColumnType()));
            metaComponent.setProperties(object.getProperties());
            object = autoMapContext.getTraversalAction(metaComponent.getTagName());
            if (object != null) {
                object.doAction(metaComponent, metaExcelCell, autoMapContext);
            }
        }
    }
}

