/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.automap.excel.template.action.container;

import com.bokesoft.yes.automap.excel.template.action.container.AbstractContainerMapAction;
import com.bokesoft.yes.automap.excel.template.out.column.EditViewColumnData;
import com.bokesoft.yes.automap.excel.template.out.column.EditViewColumnDataBuilder;
import com.bokesoft.yes.automap.excel.traveral.out.AutoMapContext;
import com.bokesoft.yes.automap.excel.traveral.out.OutContainer;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRows;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelSheet;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;

public class MapEditViewAction
extends AbstractContainerMapAction<MetaEditView> {
    @Override
    public void doAction(MetaEditView metaEditView, MetaExcelSheet metaExcelSheet, AutoMapContext<MetaExcelSheet> autoMapContext) {
        metaExcelSheet = metaExcelSheet.getRows();
        EditViewColumnDataBuilder editViewColumnDataBuilder = new EditViewColumnDataBuilder(metaEditView.getKey(), metaEditView.getColumnCollection(), autoMapContext);
        Object object = editViewColumnDataBuilder.build();
        int n = editViewColumnDataBuilder.getRowCount();
        int n2 = editViewColumnDataBuilder.getLeafCount();
        OutContainer<MetaExcelSheet> outContainer = this.installNewContainer(metaEditView.getKey(), 2, n2, autoMapContext);
        object = object.iterator();
        while (object.hasNext()) {
            EditViewColumnData editViewColumnData = (EditViewColumnData)object.next();
            this.traversalColumnAction(metaEditView, editViewColumnData, outContainer, autoMapContext);
        }
        object = this.ensureExcelRow((MetaExcelRows)metaExcelSheet, outContainer.getStartRowPos() + n);
        this.initExcelRow((MetaExcelRow)object, metaEditView, autoMapContext);
    }

    private void traversalColumnAction(MetaEditView metaEditView, EditViewColumnData editViewColumnData, OutContainer<MetaExcelSheet> outContainer, AutoMapContext<MetaExcelSheet> autoMapContext) {
        if (!autoMapContext.isNeedAutoMapField(metaEditView.getKey(), editViewColumnData.getKey())) {
            return;
        }
        metaEditView = new MetaExcelCell();
        MetaExcelRows metaExcelRows = ((MetaExcelSheet)outContainer.getMeta()).getRows();
        int n = outContainer.getStartRowPos();
        MetaExcelRow metaExcelRow = this.ensureExcelRow(metaExcelRows, n);
        metaExcelRow.setType(2);
        metaExcelRow.add((AbstractMetaObject)metaEditView);
        metaEditView.setCellIndex(autoMapContext.getStartColPos() + editViewColumnData.getCol());
        metaEditView.setMergedColumnSpan(editViewColumnData.getColSpan());
        metaEditView.setMergedRowSpan(editViewColumnData.getRowSpan());
        metaEditView.setDefinition(editViewColumnData.getCaption());
        metaEditView.setSourceType(2);
    }

    private void initExcelRow(MetaExcelRow metaExcelRow, MetaEditView metaEditView, AutoMapContext<MetaExcelSheet> autoMapContext) {
        metaExcelRow.setTableKey(metaEditView.getTableKey());
        metaExcelRow.setType(3);
        int n = 0;
        for (MetaEditViewColumn metaEditViewColumn : metaEditView.getColumnCollection()) {
            if (!autoMapContext.isNeedAutoMapField(metaEditView.getKey(), metaEditViewColumn.getKey())) continue;
            MetaExcelCell metaExcelCell = new MetaExcelCell();
            metaExcelRow.add((AbstractMetaObject)metaExcelCell);
            this.initExcelCellByColumn(metaExcelCell, metaEditViewColumn, autoMapContext.getStartColPos() + n, autoMapContext);
            ++n;
        }
    }

    private void initExcelCellByColumn(MetaExcelCell metaExcelCell, MetaEditViewColumn object, int n, AutoMapContext<MetaExcelSheet> autoMapContext) {
        if (object.hasDataBinding().booleanValue() || !StringUtil.isBlankOrNull((String)object.getCaption())) {
            metaExcelCell.setCellIndex(n);
            if (!StringUtil.isBlankOrNull((String)object.getDataColumnKey())) {
                metaExcelCell.setSourceType(0);
                metaExcelCell.setDefinition(object.getDataColumnKey());
            } else if (!StringUtil.isBlankOrNull((String)object.getDefaultFormulaValue())) {
                metaExcelCell.setSourceType(1);
                metaExcelCell.setDefinition(object.getDefaultFormulaValue());
            } else if (!StringUtil.isBlankOrNull((String)object.getDefaultValue())) {
                metaExcelCell.setSourceType(2);
                metaExcelCell.setDefinition(object.getDefaultValue());
            } else if (!StringUtil.isBlankOrNull((String)object.getCaption())) {
                metaExcelCell.setSourceType(2);
                metaExcelCell.setDefinition(object.getCaption());
            }
            MetaComponent metaComponent = MetaComponentFactory.getInstance().newComponent(ControlType.toString((int)object.getColumnType()));
            metaComponent.setProperties(object.getProperties());
            object = autoMapContext.getTraversalAction(metaComponent.getTagName());
            if (object != null) {
                object.doAction(metaComponent, metaExcelCell, autoMapContext);
            }
        }
    }
}

