/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;

public class ExcelUtil {
    private static int getDataType(Object value) {
        if (value instanceof Integer) {
            return 1001;
        }
        if (value instanceof Long) {
            return 1010;
        }
        if (value instanceof BigDecimal) {
            return 1005;
        }
        return 1002;
    }

    public static void setCellValue(Cell cell, Object value) {
        int dataType = ExcelUtil.getDataType(value);
        String str = TypeConvertor.toString((Object)value);
        switch (dataType) {
            case 1001: 
            case 1005: 
            case 1010: {
                if (StringUtil.isNum((String)str)) {
                    cell.setCellValue(TypeConvertor.toDouble((Object)value).doubleValue());
                    cell.setCellType(CellType.NUMERIC);
                    break;
                }
                cell.setCellValue(str);
                break;
            }
            default: {
                cell.setCellValue(str);
            }
        }
    }

    public static void setCellValue(Sheet sheet, int rowIndex, int colIndex, Object value) {
        Cell cell = ExcelUtil.getCell(sheet, rowIndex, colIndex);
        ExcelUtil.setCellValue(cell, value);
    }

    public static void setCellValue(Sheet sheet, int rowIndex, int colIndex, Object value, CellStyle cellStyle) {
        Cell cell = ExcelUtil.getCell(sheet, rowIndex, colIndex);
        cell.setCellStyle(cellStyle);
        ExcelUtil.setCellValue(cell, value);
    }

    public static void setCellValue(Sheet sheet, int rowIndex, int colIndex, Object value, ExcelTemplateField templateField, StampExcelStyleFactory styleFactory) {
        ExcelUtil.preMergedRegion(templateField, rowIndex, colIndex, sheet);
        ExcelUtil.preCellStyle(templateField, rowIndex, colIndex, sheet, styleFactory);
        Row row = ExcelUtil.prepareDefaultHeightRow(sheet, rowIndex);
        Cell cell = ExcelUtil.getCell(row, colIndex);
        ExcelUtil.setCellValue(cell, value);
    }

    public static Sheet getSheet(Workbook workbook, String sheetName) {
        if (workbook == null) {
            return null;
        }
        String safeSheetName = WorkbookUtil.createSafeSheetName((String)sheetName);
        Sheet sheet = workbook.getSheet(safeSheetName);
        if (sheet == null) {
            sheet = workbook.createSheet(safeSheetName);
        }
        return sheet;
    }

    public static Row getRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
            row.setHeight(sheet.getDefaultRowHeight());
        }
        return row;
    }

    public static Cell getCell(Sheet sheet, int rowIndex, int colIndex) {
        return ExcelUtil.getCell(sheet, rowIndex, colIndex, CellType.BLANK);
    }

    public static Cell getCell(Sheet sheet, int rowIndex, int colIndex, CellType cellType) {
        Row row = ExcelUtil.getRow(sheet, rowIndex);
        Cell cell = ExcelUtil.getCell(row, colIndex, cellType);
        return cell;
    }

    public static Cell getCell(Row row, int colIndex) {
        return ExcelUtil.getCell(row, colIndex, CellType.BLANK);
    }

    public static Cell getCell(Row row, int colIndex, CellType cellType) {
        Cell cell = row.getCell(colIndex);
        if (cell == null) {
            cell = row.createCell(colIndex, cellType);
        }
        return cell;
    }

    public static Object getCellValue(Sheet sheet, int rowIndex, int colIndex) {
        Cell cell = ExcelUtil.getCell(sheet, rowIndex, colIndex);
        Object value = null;
        switch (cell.getCellType()) {
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    value = HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue());
                    break;
                }
                HSSFDataFormatter df = new HSSFDataFormatter();
                value = df.formatCellValue(cell);
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            default: {
                value = "";
            }
        }
        return value;
    }

    public static void calcMaxColumnWidth(Cell cell, HashMap<Integer, Integer> columnWidth, int colIndex) {
        String value = null;
        value = cell.getCellType() == CellType.NUMERIC ? String.valueOf(cell.getNumericCellValue()) : cell.getStringCellValue();
        int width = value.getBytes().length * 256;
        if (columnWidth.containsKey(colIndex)) {
            width = Math.max(columnWidth.get(colIndex), width);
        }
        width = Math.min(64780, width);
        columnWidth.put(colIndex, width);
    }

    public static void calcFinalColumnWith(HashMap<Integer, Integer> templateColumnWidth, HashMap<Integer, Integer> columnWidth) {
        if (templateColumnWidth == null) {
            return;
        }
        for (Map.Entry<Integer, Integer> entry : columnWidth.entrySet()) {
            if (!templateColumnWidth.containsKey(entry.getKey())) continue;
            int templateWith = templateColumnWidth.get(entry.getKey());
            int with = Math.max(templateWith / 80 * 2048, entry.getValue());
            entry.setValue(with);
        }
    }

    public static void setSheetColumnWidth(Sheet sheet, HashMap<Integer, Integer> columnWidth) {
        int colIndex2 = 0;
        for (int colIndex2 : columnWidth.keySet()) {
            sheet.setColumnWidth(colIndex2, columnWidth.get(colIndex2) + 500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeExcel(Workbook workbook, String sExportFileName, boolean needCloseWorkbook) throws Throwable {
        FileOutputStream out = null;
        if (!sExportFileName.trim().endsWith(".xlsx") && !sExportFileName.trim().endsWith(".xls")) {
            sExportFileName = (sExportFileName + ".xlsx").trim();
        }
        File file = new File(sExportFileName);
        try {
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            out = new FileOutputStream(sExportFileName);
            workbook.write((OutputStream)out);
            out.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (needCloseWorkbook && workbook != null) {
                workbook.close();
            }
            if (needCloseWorkbook && out != null) {
                out.close();
            }
        }
        return file;
    }

    public static void setCellFormula(Sheet sheet, int rowIndex, int colIndex, String formula) {
        Cell cell = ExcelUtil.getCell(sheet, rowIndex, colIndex);
        cell.setCellFormula(formula);
    }

    public static Row insertRow(Sheet sheet, int afterRowIndex) {
        ExcelUtil.ensureRow(sheet, afterRowIndex + 1);
        sheet.shiftRows(afterRowIndex, sheet.getLastRowNum(), 1, true, false);
        Row insertRow = sheet.createRow(afterRowIndex);
        insertRow.setHeight(sheet.getDefaultRowHeight());
        return insertRow;
    }

    public static Row ensureRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (row != null) {
            return row;
        }
        for (int n = sheet.getLastRowNum() + 1; n <= rowIndex; ++n) {
            Row newRow = sheet.createRow(n);
            newRow.setHeight(sheet.getDefaultRowHeight());
        }
        return sheet.getRow(rowIndex);
    }

    public static Row prepareDefaultHeightRow(Sheet sheet, int rowIndex) {
        Row row = ExcelUtil.getRow(sheet, rowIndex);
        row.setHeight(sheet.getDefaultRowHeight());
        return row;
    }

    public static void prepareSheet(Sheet sheet, int preRowCount) {
        if (sheet.getLastRowNum() >= preRowCount) {
            return;
        }
        for (int n = sheet.getLastRowNum(); n <= preRowCount; ++n) {
            Row newRow = sheet.createRow(n);
            newRow.setHeight(sheet.getDefaultRowHeight());
        }
    }

    private static void preMergedRegion(ExcelTemplateField templateField, int rowIndex, int colIndex, Sheet sheet) {
        int rowSpan = templateField.getRowSpan() - 1;
        int colSpan = templateField.getColSpan() - 1;
        if (colSpan > 0 || rowSpan > 0) {
            sheet.addMergedRegionUnsafe(new CellRangeAddress(rowIndex, rowIndex + rowSpan, colIndex, colIndex + colSpan));
        }
    }

    private static void preCellStyle(ExcelTemplateField templateField, int rowIndex, int colIndex, Sheet sheet, StampExcelStyleFactory styleFactory) {
        CellStyle cellStyle = styleFactory.getCellStyle(templateField);
        Cell cell = ExcelUtil.getCell(sheet, rowIndex, colIndex);
        int rowSpan = templateField.getRowSpan() - 1;
        int colSpan = templateField.getColSpan() - 1;
        if (colSpan > 0 || rowSpan > 0) {
            for (int c = 0; c <= colSpan; ++c) {
                for (int r = 0; r <= rowSpan; ++r) {
                    cell = ExcelUtil.getCell(sheet, rowIndex + r, colIndex + c);
                    cell.setCellStyle(cellStyle);
                }
            }
        } else {
            cell.setCellStyle(cellStyle);
        }
    }
}

