/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template.builder;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateColumnExpand;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateFieldFormat;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.builder.IExcelTemplateBuilder;
import com.bokesoft.yes.excel.template.util.ExcelTemplateUtils;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateCellType;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.util.MetaUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class SheetTemplateBuilder
implements IExcelTemplateBuilder {
    private String templateKey = null;
    private Sheet sysSheet = null;
    private IMetaFactory metaFactory = null;

    public SheetTemplateBuilder(String templateKey, Workbook workbook, IMetaFactory metaFactory) {
        this.templateKey = templateKey;
        this.metaFactory = metaFactory;
        this.sysSheet = workbook.getSheet("YIGO_TEMPLATE");
    }

    @Override
    public ExcelTemplate create() throws Throwable {
        String sBinding;
        int startRow = 1;
        ExcelTemplate excelTemplate = new ExcelTemplate(this.templateKey);
        int totalRowCount = this.sysSheet.getLastRowNum();
        int version = TypeConvertor.toInteger((Object)ExcelUtil.getCellValue(this.sysSheet, startRow, 0));
        excelTemplate.setVersion(version);
        String formKey = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, startRow, 1));
        excelTemplate.setFormKey(formKey);
        String sType = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, startRow, 2));
        excelTemplate.setType(EExcelTemplateType.valueOf((String)sType));
        MetaForm metaForm = this.metaFactory.getMetaForm(formKey);
        MetaDataObject dataObject = MetaUtil.getDataObject((IMetaFactory)this.metaFactory, (MetaForm)metaForm);
        int rowIndex = startRow;
        String sTempKey = null;
        String tableKey = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, rowIndex, 4));
        ExcelTemplateTable templateTable = new ExcelTemplateTable(tableKey);
        this.setDtlTable(templateTable, dataObject, excelTemplate);
        ExcelTemplateSheet tempateSheet = null;
        while (rowIndex <= totalRowCount && !StringUtil.isBlankOrNull((String)(sBinding = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, rowIndex, 5))))) {
            String sDefine = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, rowIndex, 6));
            ExcelTemplateField templateField = ExcelTemplateUtils.parseCellBindingToTemplate(sBinding, sDefine);
            if (templateField == null) {
                if (StringUtil.isBlankOrNull((String)(sTempKey = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, ++rowIndex, 4)))) || sTempKey.equalsIgnoreCase(templateTable.getTableKey())) continue;
                templateTable = new ExcelTemplateTable(sTempKey);
                this.setDtlTable(templateTable, dataObject, excelTemplate);
                continue;
            }
            String sheetName = templateField.getSheetName();
            if (!StringUtil.isBlankOrNull((String)sheetName) && !(tempateSheet = excelTemplate.ensureTemplateSheet(sheetName)).containTableKey(templateTable.getTableKey())) {
                tempateSheet.addTemplateTable(templateTable);
            }
            if (templateTable.isDtlTable()) {
                templateTable.setStartDtlRowIndex(templateField.getRowIndex());
            }
            String sSourceType = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, rowIndex, 7));
            int sourceType = ExcelTemplateCellType.parse((String)sSourceType);
            templateField.setSourceType(sourceType);
            String sFormat = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, rowIndex, 8));
            ExcelTemplateFieldFormat format = new ExcelTemplateFieldFormat(sFormat);
            templateField.setFormat(format);
            String checkRule = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, rowIndex, 9));
            templateField.setCheckRule(checkRule);
            boolean bIgnore4Import = TypeConvertor.toBoolean((Object)ExcelUtil.getCellValue(this.sysSheet, rowIndex, 11));
            templateField.setIgnore4Import(bIgnore4Import);
            String ignoreExport = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, rowIndex, 12));
            templateField.setIgnoreExport(ignoreExport);
            Boolean isDetailLinked = TypeConvertor.toBoolean((Object)ExcelUtil.getCellValue(this.sysSheet, rowIndex, 10));
            templateField.setDetailLinkField(isDetailLinked);
            templateField.setTableKey(templateTable.getTableKey());
            templateTable.addField(templateField);
            if (isDetailLinked.booleanValue() && excelTemplate.getDetailLinkedField() == null) {
                excelTemplate.setDetailLinkedField(templateField);
            }
            String sColumnExpand = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, rowIndex, 13));
            ExcelTemplateColumnExpand columnExpand = new ExcelTemplateColumnExpand(sColumnExpand);
            templateField.setColumnExpand(columnExpand);
            if (StringUtil.isBlankOrNull((String)(sTempKey = TypeConvertor.toString((Object)ExcelUtil.getCellValue(this.sysSheet, ++rowIndex, 4)))) || sTempKey.equalsIgnoreCase(templateTable.getTableKey())) continue;
            templateTable = new ExcelTemplateTable(sTempKey);
            this.setDtlTable(templateTable, dataObject, excelTemplate);
        }
        return excelTemplate;
    }

    private void setDtlTable(ExcelTemplateTable templateTable, MetaDataObject dataObject, ExcelTemplate excelTemplate) {
        MetaTable metaTable = dataObject.getTable(templateTable.getTableKey());
        if (metaTable == null) {
            return;
        }
        boolean bDtl = 1 == metaTable.getTableMode() || EExcelTemplateType.Batch == excelTemplate.getType() || EExcelTemplateType.MultiBatch == excelTemplate.getType();
        templateTable.setDtlTable(bDtl);
    }
}

