/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template.builder;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.builder.IExcelTemplateBuilder;
import com.bokesoft.yes.excel.template.util.ExcelTemplateUtils;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelSheet;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MetaSingleTemplateBuilder
implements IExcelTemplateBuilder {
    private MetaDataObject dataObject = null;
    private MetaExcelWorkbook metaWorkbook = null;

    public MetaSingleTemplateBuilder(MetaExcelWorkbook metaWorkbook, MetaDataObject dataObject) {
        this.dataObject = dataObject;
        this.metaWorkbook = metaWorkbook;
    }

    @Override
    public ExcelTemplate create() throws Throwable {
        ExcelTemplateTable templateTable = null;
        ExcelTemplate excelTemplate = ExcelTemplateUtils.createTemplate(this.metaWorkbook.getKey(), this.metaWorkbook.getFormKey(), this.dataObject.getKey(), this.metaWorkbook.isNeedResetCellIndex(), EExcelTemplateType.Single);
        for (MetaExcelSheet sheet : this.metaWorkbook.getList()) {
            ExcelTemplateSheet sheetTemplate = excelTemplate.ensureTemplateSheet(sheet.getName());
            ExcelTemplateUtils.createSheetColumnSize(sheet, sheetTemplate);
            ArrayList<MetaExcelCell> dealedCellList = new ArrayList<MetaExcelCell>();
            LinkedList<ExcelTemplateField> tmpDetailHeadFields = new LinkedList<ExcelTemplateField>();
            for (int indexOfRows = 0; indexOfRows < sheet.getRows().size(); ++indexOfRows) {
                MetaExcelRow row = (MetaExcelRow)sheet.getRows().get(indexOfRows);
                for (MetaExcelCell cell : row) {
                    templateTable = this.ensureTemplateTable(indexOfRows, cell, sheetTemplate, sheet);
                    ExcelTemplateField templateField = this.createDetailExcelTemplateField(indexOfRows, cell.getCellIndex(), templateTable, sheet, dealedCellList);
                    if (templateField == null) continue;
                    if (row.getType() == 2) {
                        tmpDetailHeadFields.add(templateField);
                        continue;
                    }
                    if (row.getType() != 3) continue;
                    templateTable.fillDetailHeadFields(tmpDetailHeadFields);
                    tmpDetailHeadFields.clear();
                }
            }
        }
        return excelTemplate;
    }

    private ExcelTemplateTable ensureTemplateTable(int indexOfRow, MetaExcelCell cell, ExcelTemplateSheet sheetTemplate, MetaExcelSheet sheet) {
        MetaExcelRow row = (MetaExcelRow)sheet.getRows().get(indexOfRow);
        String tableKey = row.getTableKey();
        String cellTableKey = StringUtil.isBlankOrNull((String)tableKey) ? cell.getTableKey() : tableKey;
        ExcelTemplateTable templateTable = sheetTemplate.ensureTemplateTable(cellTableKey);
        if (row.getType() == 3) {
            templateTable.setDtlTable(true);
            templateTable.setRowHeight(row.getHeight());
            templateTable.setStartDtlRowIndex(row.getRowIndex());
        }
        return templateTable;
    }

    private ExcelTemplateField createDetailExcelTemplateField(int indexOfRows, int cellIndex, ExcelTemplateTable templateTable, MetaExcelSheet sheet, List<MetaExcelCell> dealedCellList) {
        ExcelTemplateField templateField;
        if (indexOfRows >= sheet.getRows().size()) {
            return null;
        }
        MetaExcelRow row = (MetaExcelRow)sheet.getRows().get(indexOfRows);
        MetaExcelCell cell = this.findCellByCellIndex(cellIndex, row);
        if (dealedCellList.contains(cell) || cell == null) {
            return null;
        }
        dealedCellList.add(cell);
        if (row.getType() == 3 && cell.isColumnExpand()) {
            templateField = this.createDetailExcelTemplateField(indexOfRows + 1, cellIndex, templateTable, sheet, dealedCellList);
            if (templateField != null) {
                ExcelTemplateField expandDimensionField = ExcelTemplateField.create(cell.getDefinition(), row.getRowIndex(), cell.getCellIndex(), sheet.getName());
                ExcelTemplateUtils.initTemplateFieldByMeta(expandDimensionField, cell, false);
                templateField.addExpandDimensionField(expandDimensionField);
                templateTable.addField(expandDimensionField);
            }
        } else {
            templateField = ExcelTemplateField.create(cell.getDefinition(), row.getRowIndex(), cell.getCellIndex(), sheet.getName());
            ExcelTemplateUtils.initTemplateFieldByMeta(templateField, cell, false);
            templateTable.addField(templateField);
        }
        return templateField;
    }

    private MetaExcelCell findCellByCellIndex(int cellIndex, MetaExcelRow row) {
        for (MetaExcelCell cell : row) {
            if (cell.getCellIndex() != cellIndex) continue;
            return cell;
        }
        return null;
    }
}

