/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.tools.document;

import com.bokesoft.yes.common.struct.MultiKey;
import com.bokesoft.yes.common.struct.MultiKeyNode;
import com.bokesoft.yes.common.struct.report.MultiDimNode;
import com.bokesoft.yes.common.struct.report.MultiDimValue;
import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataTableUtil {
    public static Map<MetaTable, DataTableMetaData> cacheMetaDataMap = new HashMap<MetaTable, DataTableMetaData>();

    public static DataTable newEmptyDataTable(MetaTable metaTable) {
        if (metaTable == null) {
            throw new RuntimeException("MetaTable\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DataTableMetaData dataTableMetaData = cacheMetaDataMap.get(metaTable);
        boolean isDiff = DataTableUtil.checkMetaTableColumnInfo(metaTable, dataTableMetaData);
        if (!isDiff) {
            DataTable dataTable = new DataTable(dataTableMetaData);
            dataTable.setKey(metaTable.getKey());
            dataTable.setCheckLenght(metaTable.isPersist());
            return dataTable;
        }
        cacheMetaDataMap.remove(metaTable);
        dataTableMetaData = null;
        DataTable table = new DataTable();
        table.setKey(metaTable.getKey());
        table.setCheckLenght(metaTable.isPersist());
        Iterator it = metaTable.iterator();
        MetaColumn metaColumn = null;
        int index = 0;
        while (it.hasNext()) {
            metaColumn = (MetaColumn)it.next();
            if (metaColumn.isHidden() || metaColumn.isSupportI18n()) continue;
            String columnKey = metaColumn.getKey();
            ColumnInfo columnInfo = new ColumnInfo(columnKey, metaColumn.getDataType());
            columnInfo.setAccessControl(metaColumn.isAccessControl());
            columnInfo.setPrimary(metaColumn.getIsPrimary());
            columnInfo.setDefaultValue(metaColumn.getDefaultValue());
            columnInfo.setScale(metaColumn.getScale());
            columnInfo.setLength(metaColumn.getLength());
            columnInfo.setCodeColumnKey(metaColumn.getCodeColumnKey());
            if (metaColumn.isIgnoreQuery()) {
                table.addColumn(columnInfo);
                continue;
            }
            table.addColumn(index, columnInfo);
            ++index;
        }
        cacheMetaDataMap.put(metaTable, table.getMetaData());
        return table;
    }

    private static boolean checkMetaTableColumnInfo(MetaTable metaTable, DataTableMetaData dataTableMetaData) {
        if (dataTableMetaData == null) {
            return true;
        }
        if (metaTable.size() != dataTableMetaData.getColumnCount()) {
            return true;
        }
        for (MetaColumn column : metaTable) {
            String columnKey = column.getKey();
            int columnIndex = dataTableMetaData.findColumnIndexByKey(columnKey);
            if (columnIndex >= 0) continue;
            return true;
        }
        return false;
    }

    public static void getIndexesAndTypes(DataTable table, List<String> columnKeys, int[] indexes, int[] types) throws Throwable {
        DataTableMetaData tableMetaData = table.getMetaData();
        for (int i = 0; i < columnKeys.size(); ++i) {
            ColumnInfo columnInfo = tableMetaData.getColumnInfo(columnKeys.get(i));
            indexes[i] = tableMetaData.findColumnIndexByKey(columnInfo.getColumnKey());
            types[i] = columnInfo.getUserDataType();
        }
    }

    public static int locate(DataTable table, MultiDimValue dimValue) {
        MultiDimNode node = null;
        MultiDimValue other = null;
        table.beforeFirst();
        while (table.next()) {
            other = new MultiDimValue();
            int size = dimValue.size();
            for (int i = 0; i < size; ++i) {
                node = dimValue.getValue(i);
                other.addValue(DataTableUtil.makeDimNode(table, node.getColumnKey()));
            }
            if (!dimValue.equals((Object)other)) continue;
            return table.getBookmark();
        }
        return -1;
    }

    public static MultiDimValue makeDimValue(DataTable table, List<String> columnKeys) {
        MultiDimValue dimValue = new MultiDimValue();
        for (String columnKey : columnKeys) {
            dimValue.addValue(DataTableUtil.makeDimNode(table, columnKey));
        }
        return dimValue;
    }

    private static MultiDimNode makeDimNode(DataTable table, String columnKey) {
        ColumnInfo info = table.getMetaData().getColumnInfo(columnKey);
        Object value = table.getObject(columnKey);
        MultiDimNode node = new MultiDimNode(columnKey, info.getDataType(), value);
        return node;
    }

    public static MultiKey makeMultiKey(DataTable table, int[] indexes, int[] types) {
        MultiKey value = new MultiKey();
        int length = indexes.length;
        for (int i = 0; i < length; ++i) {
            value.addValue(new MultiKeyNode(types[i], table.getObject(indexes[i])));
        }
        return value;
    }

    public static MultiKey convertDimValue(MultiDimValue dimValue) {
        MultiKey key = new MultiKey();
        int size = dimValue.size();
        for (int i = 0; i < size; ++i) {
            MultiDimNode dimNode = dimValue.getValue(i);
            MultiKeyNode node = new MultiKeyNode(DBTypeUtil.dataType2JavaDataType((int)dimNode.getDataType()), dimNode.getValue());
            key.addValue(node);
        }
        return key;
    }

    public static void append(DataTable src, DataTable tgt, MetaTable metaTable) throws Throwable {
        DataTableUtil.append(src, tgt, metaTable, -1);
    }

    public static void append(DataTable src, DataTable tgt, MetaTable metaTable, int parentBkmk) throws Throwable {
        DataTableMetaData srcMetaData = src.getMetaData();
        DataTableMetaData tgtMetaData = tgt.getMetaData();
        int colIndex = -1;
        ColumnInfo tgtCoInfo = null;
        Iterator it = null;
        String key = null;
        src.beforeFirst();
        while (src.next()) {
            DocumentUtil.newRow(metaTable, tgt);
            for (MetaColumn metaColumn : metaTable) {
                if (metaColumn.isSupportI18n()) continue;
                key = metaColumn.getKey();
                colIndex = srcMetaData.findColumnIndexByKey(key);
                tgtCoInfo = tgtMetaData.getColumnInfo(key);
                if (tgtCoInfo == null || colIndex < 0) continue;
                tgt.setObject(key, TypeConvertor.toDataType((int)tgtCoInfo.getDataType(), (Object)src.getObject(key)));
            }
            if (parentBkmk == -1) continue;
            tgt.setParentBookmark(parentBkmk);
        }
    }

    public static void appendAll(DataTable src, DataTable tgt) {
        src.beforeFirst();
        int count = src.getMetaData().getColumnCount();
        while (src.next()) {
            tgt.append();
            tgt.setState(tgt.getState());
            for (int i = 0; i < count; ++i) {
                tgt.setObject(i, src.getObject(i));
            }
        }
    }
}

