/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.rights;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yigo.common.json.JSONSerializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class CustomRights
implements JSONSerializable {
    private boolean hasAllRights = false;
    private Map<String, Set<String>> rightLists = new HashMap<String, Set<String>>();

    public Map<String, Set<String>> getRightLists() {
        return this.rightLists;
    }

    public void setRightLists(Map<String, Set<String>> rightLists) {
        this.rightLists = rightLists;
    }

    public void addRights(String groupKey, String optKey) {
        if (this.hasAllRights) {
            return;
        }
        if (groupKey.equalsIgnoreCase("*")) {
            this.hasAllRights = true;
        } else if (!this.contains(groupKey, optKey)) {
            this.getGroup(groupKey).add(optKey);
        }
    }

    public void removeRights(String groupKey, String optKey) {
        this.getGroup(groupKey).remove(optKey);
    }

    public boolean contains(String groupKey, String optKey) {
        if (this.hasAllRights) {
            return true;
        }
        return this.getGroup(groupKey).contains(optKey);
    }

    private Set<String> getGroup(String groupKey) {
        Set<String> s = this.rightLists.get(groupKey);
        if (s == null) {
            s = new HashSet<String>();
            this.rightLists.put(groupKey, s);
        }
        return s;
    }

    public CustomRights clone() {
        CustomRights clone = new CustomRights();
        clone.merge(this);
        return clone;
    }

    public void merge(CustomRights cr) {
        if (cr == null) {
            return;
        }
        if (!this.hasAllRights && cr.hasAllRights) {
            this.hasAllRights = cr.hasAllRights;
        }
        for (Map.Entry<String, Set<String>> en : cr.rightLists.entrySet()) {
            Set<String> s = this.rightLists.get(en.getKey());
            if (s == null) {
                this.rightLists.put(en.getKey(), en.getValue());
                continue;
            }
            s.addAll((Collection<String>)en.getValue());
        }
    }

    public boolean isHasAllRights() {
        return this.hasAllRights;
    }

    public void setHasAllRights(boolean hasAllRights) {
        this.hasAllRights = hasAllRights;
    }

    public Set<Map.Entry<String, Set<String>>> CustomRightsSet() {
        return this.rightLists.entrySet();
    }

    public JSONObject toJSON() throws Throwable {
        JSONObject jsonObj = new JSONObject();
        if (this.hasAllRights) {
            jsonObj.put("allRights", true);
        } else {
            JSONObject rightsJSON = new JSONObject();
            Set<String> set = null;
            String key = null;
            for (Map.Entry<String, Set<String>> param : this.rightLists.entrySet()) {
                key = param.getKey();
                set = param.getValue();
                if (key == null || key.isEmpty() || set == null || set.isEmpty()) continue;
                rightsJSON.put(param.getKey(), (Object)this.toJSONArray(set));
            }
            jsonObj.put("allRights", false);
            jsonObj.put("rightsList", (Object)rightsJSON);
        }
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws Throwable {
        JSONObject json;
        this.hasAllRights = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"allRights", (boolean)false);
        if (!this.hasAllRights && (json = jsonObj.optJSONObject("rightsList")) != null) {
            this.rightLists = this.toMap(json);
        }
    }

    private Map<String, Set<String>> toMap(JSONObject jsonObj) throws Throwable {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        Iterator it = jsonObj.keys();
        JSONArray jsonArray = null;
        HashSet<String> set = null;
        while (it.hasNext()) {
            String key;
            Object o = it.next();
            if (!(o instanceof String) || (jsonArray = jsonObj.getJSONArray(key = (String)o)) == null || jsonArray.length() <= 0) continue;
            set = new HashSet<String>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                set.add(jsonArray.getString(i));
            }
            map.put(key, set);
        }
        return map;
    }

    private JSONArray toJSONArray(Collection<?> collection) throws Throwable {
        if (collection == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        Iterator<?> iter = collection.iterator();
        Object value = null;
        while (iter.hasNext()) {
            value = iter.next();
            jsonArray.put(value);
        }
        return jsonArray;
    }
}

