/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.expand;

import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.common.struct.PairItem;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.expand.IExpandDimensionField;
import com.bokesoft.yigo.struct.expand.IExpandSourceField;
import com.bokesoft.yigo.struct.expand.IExpandTableDefine;
import com.bokesoft.yigo.struct.expand.processor.DimensionItem;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDimensionsCreator<S extends IExpandSourceField<F>, F extends IExpandDimensionField> {
    public List<DimensionItem<IPairItem, S, F>> createDimensions(IExpandTableDefine<S, F> tableDefine) throws Throwable {
        ArrayList<DimensionItem<IPairItem, S, F>> rootDimensionItems = new ArrayList<DimensionItem<IPairItem, S, F>>();
        List<S> expandFields = tableDefine.getExpandFields();
        if (expandFields != null) {
            for (IExpandSourceField expandField : expandFields) {
                DimensionItem<IPairItem, IExpandSourceField, F> rootDimensionItem = this.createDimensionRootItem(expandField, tableDefine);
                rootDimensionItems.add(rootDimensionItem);
            }
        }
        return rootDimensionItems;
    }

    private DimensionItem<IPairItem, S, F> createDimensionRootItem(S expandField, IExpandTableDefine<S, F> tableDefine) throws Throwable {
        PairItem item = new PairItem((Object)expandField.getKey(), expandField.getKey());
        DimensionItem<PairItem, S, Object> root = new DimensionItem<PairItem, S, Object>(item, null, expandField);
        ArrayList<DimensionItem<PairItem, S, Object>> parentLevelDimensionItems = new ArrayList<DimensionItem<PairItem, S, Object>>();
        parentLevelDimensionItems.add(root);
        Object dimensionField = null;
        for (String dimensionFieldKey : expandField.getDimensionFieldKeys()) {
            dimensionField = tableDefine.getDimensionField(dimensionFieldKey);
            ArrayList<DimensionItem<IPairItem, S, Object>> curLevelDimensionItems = new ArrayList<DimensionItem<IPairItem, S, Object>>();
            List<IPairItem> dimensionValues = this.getDimensionValues(dimensionField);
            for (IPairItem dimensionValue : dimensionValues) {
                for (DimensionItem dimensionItem : parentLevelDimensionItems) {
                    DimensionItem<IPairItem, S, Object> dimensionItem2 = new DimensionItem<IPairItem, S, Object>(dimensionValue, dimensionField, expandField);
                    dimensionItem.addChild(dimensionItem2);
                    curLevelDimensionItems.add(dimensionItem2);
                }
            }
            parentLevelDimensionItems = curLevelDimensionItems;
        }
        return root;
    }

    public static List<IPairItem> parseToListItems(String content) {
        ArrayList<IPairItem> items = new ArrayList<IPairItem>();
        String s = content;
        for (String tmp : s.split(";")) {
            int commaPos = tmp.indexOf(44);
            String value = tmp.substring(0, commaPos);
            String caption = tmp.substring(commaPos + 1);
            items.add((IPairItem)new PairItem((Object)value, caption));
        }
        return items;
    }

    public static List<IPairItem> parseToListItems(DataTable table) {
        ArrayList<IPairItem> items = new ArrayList<IPairItem>();
        table.beforeFirst();
        while (table.next()) {
            Object value = table.getObject(0);
            Object objCaption = table.getObject(1);
            String caption = objCaption == null ? "" : objCaption.toString();
            items.add((IPairItem)new PairItem(value, caption));
        }
        return items;
    }

    protected abstract List<IPairItem> getDimensionValues(F var1) throws Throwable;
}

