/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.document;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.struct.datatable.json.DataTableListImpl;
import com.bokesoft.yes.struct.datatable.json.ExpandDataClassImpl;
import com.bokesoft.yes.struct.datatable.json.ExpandDataImpl;
import com.bokesoft.yes.struct.datatable.json.ExpandDataTypeImpl;
import com.bokesoft.yes.struct.document.IJSONHandler;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.DocumentType;
import com.bokesoft.yigo.struct.document.track.DocumentTrack;
import com.bokesoft.yigo.struct.exception.StructException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class Document
implements JSONSerializable,
IJSONHandler {
    public static final int NORMAL = 0;
    public static final int NEW = 1;
    public static final int MODIFIED = 2;
    public static final int DELETE = 3;
    private String objectKey = "";
    private Long OID = -1L;
    private Long POID = null;
    private Integer VERID = 0;
    private Integer DVERID = 0;
    private int state = 0;
    private int documentType = 1;
    private ArrayList<DataTable> tableList = new ArrayList();
    private StringHashMap<DataTable> dataTableMap = StringHashMap.newInstance();
    private StringHashMap<DataTable> shadowTableMap = StringHashMap.newInstance();
    private StringHashMap<Object> expandData = StringHashMap.newInstance();
    private MetaDataObject metaDataObject = null;
    private boolean withShadowTable = false;
    private DocumentTrack documentTrack = null;

    public Document(MetaDataObject metaDataObject, long OID) {
        this.metaDataObject = metaDataObject;
        if (metaDataObject != null) {
            this.objectKey = metaDataObject.getKey();
        }
        this.OID = OID;
    }

    public void clear() {
        this.tableList.clear();
        this.dataTableMap.clear();
        this.shadowTableMap.clear();
    }

    public void add(String key, DataTable table) {
        this.tableList.add(table);
        table.setKey(key);
        this.dataTableMap.put((Object)key, (Object)table);
    }

    public void remove(String key) {
        DataTable table = (DataTable)this.dataTableMap.get((Object)key);
        this.tableList.remove(table);
        this.dataTableMap.remove((Object)key);
    }

    public DataTable get(String key) {
        return (DataTable)this.dataTableMap.get((Object)key);
    }

    public void addShadowTable(String key, DataTable shadowTable) {
        this.shadowTableMap.put((Object)key, (Object)shadowTable);
    }

    public DataTable getShadowTable(String key) {
        return (DataTable)this.shadowTableMap.get((Object)key);
    }

    public Set<String> shadowKeys() {
        return this.shadowTableMap.keySet();
    }

    public void clearAllShadow() {
        this.shadowTableMap.clear();
    }

    public void put(String key, DataTable table) {
        if (this.dataTableMap.containsKey((Object)key)) {
            DataTable oldTable = (DataTable)this.dataTableMap.get((Object)key);
            for (int i = 0; i < this.tableList.size(); ++i) {
                DataTable tmpTable = this.tableList.get(i);
                if (tmpTable != oldTable) continue;
                this.tableList.set(i, table);
                break;
            }
            this.dataTableMap.put((Object)key, (Object)table);
        } else {
            this.add(key, table);
        }
    }

    public int size() {
        return this.tableList.size();
    }

    public DataTable get(int index) {
        return this.tableList.get(index);
    }

    public void reSetIDValue(DataTable head) {
        if (this.metaDataObject != null && this.OID != -1L && head != null && head.first()) {
            DataTableMetaData meta = head.getMetaData();
            if (meta.constains("POID")) {
                this.POID = head.getLong(0, "POID");
            }
            if (meta.constains("VERID")) {
                this.VERID = head.getInt(0, "VERID");
            }
            if (meta.constains("DVERID")) {
                this.DVERID = head.getInt(0, "DVERID");
            }
        }
    }

    public void reSetIDValue() throws StructException {
        if (this.metaDataObject != null) {
            MetaTable table = this.metaDataObject.getMainTable();
            DataTable head = this.get(table.getKey());
            this.reSetIDValue(head);
        }
    }

    public int getVERID() {
        return this.VERID;
    }

    public void setVERID(int VERID) {
        this.VERID = VERID;
    }

    public int getDVERID() {
        return this.DVERID;
    }

    public void setDVERID(int DVERID) {
        this.DVERID = DVERID;
    }

    public void setOID(long OID) {
        this.OID = OID;
    }

    public long getOID() {
        return this.OID;
    }

    @Deprecated
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    @Deprecated
    public String getObjectKey() {
        return this.objectKey;
    }

    public void setPOID(Long POID) {
        this.POID = POID;
    }

    public Long getPOID() {
        return this.POID;
    }

    public boolean isNew() {
        return this.state == 1;
    }

    public void setNew() {
        this.state = 1;
    }

    public void setNormal() {
        this.state = 0;
    }

    public void setModified() {
        if (this.state == 0) {
            this.state = 2;
        }
    }

    public boolean isModified() {
        return this.state == 2;
    }

    public void setDelete() {
        this.state = 3;
    }

    public boolean isDelete() {
        return this.state == 3;
    }

    public int getState() {
        return this.state;
    }

    public int getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(int documentType) {
        this.documentType = documentType;
    }

    public Iterator<DataTable> iterator() {
        return this.tableList.iterator();
    }

    public StringHashMap<Object> getAllExpandData() {
        return this.expandData;
    }

    public void putExpandData(String key, Object value) {
        this.expandData.put((Object)key, value);
    }

    public Object getExpandData(String key) {
        return this.expandData.get((Object)key);
    }

    public void removeExpandData(String key) {
        this.expandData.remove((Object)key);
    }

    public DocumentTrack getDocumentTrack() {
        if (this.documentTrack == null) {
            this.documentTrack = new DocumentTrack();
        }
        return this.documentTrack;
    }

    public void setMetaDataObject(MetaDataObject metaDataObject) {
        this.metaDataObject = metaDataObject;
        if (metaDataObject != null) {
            this.objectKey = metaDataObject.getKey();
        }
    }

    public MetaDataObject getMetaDataObject() {
        return this.metaDataObject;
    }

    public boolean withShadow() {
        return this.withShadowTable;
    }

    public void setWithShadow(boolean withShadowTable) {
        this.withShadowTable = withShadowTable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<Document OID=\"");
        sb.append(this.OID);
        sb.append("\" POID=\"");
        sb.append(this.POID);
        sb.append("\" VERID=\"");
        sb.append(this.VERID);
        sb.append("\" DVERID=\"");
        sb.append(this.DVERID);
        sb.append("\" isNew=\"");
        sb.append(this.isNew());
        sb.append("\" documentType=\"");
        sb.append(DocumentType.toString(this.documentType));
        sb.append("\">\n");
        for (DataTable table : this.tableList) {
            table.appendString(sb, true);
        }
        sb.append("</Document>\n");
        return sb.toString();
    }

    public JSONObject headTableToJSON() throws Throwable {
        if (this.metaDataObject == null) {
            return null;
        }
        JSONObject jsonObj = new JSONObject();
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"object_key", (String)this.objectKey, (String)"");
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"oid", (long)this.OID, (long)-1L);
        if (this.POID != null) {
            JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"poid", (long)this.POID, (long)-1L);
        }
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"verid", (int)this.VERID, (int)0);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"dverid", (int)this.DVERID, (int)0);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"state", (int)this.state, (int)0);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"document_type", (int)this.documentType, (int)1);
        JSONArray tableArray = new JSONArray();
        Iterator it = this.dataTableMap.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            String key = (String)entry.getKey();
            if (this.metaDataObject.getTable(key).getTableMode() != 0) continue;
            DataTable dt = (DataTable)entry.getValue();
            JSONObject dataTableObj = dt.toJSON();
            JSONHelper.writeToJSON((JSONObject)dataTableObj, (String)"key", (String)key, (String)"");
            tableArray.put((Object)dataTableObj);
        }
        jsonObj.put("table_list", (Object)tableArray);
        return jsonObj;
    }

    public JSONObject toJSON(boolean headOnly) throws Throwable {
        return this.toJSONImpl(headOnly);
    }

    public JSONObject toJSON() throws Throwable {
        return this.toJSONImpl(false);
    }

    private JSONObject toJSONImpl(boolean headOnly) throws Throwable {
        JSONObject jsonObj = new JSONObject();
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"object_key", (String)this.objectKey, (String)"");
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"oid", (long)this.OID, (long)-1L);
        if (this.POID != null) {
            JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"poid", (long)this.POID, (long)-1L);
        }
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"verid", (int)this.VERID, (int)0);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"dverid", (int)this.DVERID, (int)0);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"state", (int)this.state, (int)0);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"document_type", (int)this.documentType, (int)1);
        if (this.metaDataObject != null) {
            jsonObj.put("version", this.metaDataObject.getVersion());
            jsonObj.put("mainTableKey", (Object)this.metaDataObject.getMainTableKey());
        }
        JSONArray tableArray = new JSONArray();
        Iterator it = this.dataTableMap.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            MetaTable metaTable;
            entry = (Map.Entry)it.next();
            String key = (String)entry.getKey();
            if (headOnly) {
                String mainTableKey;
                String string = mainTableKey = this.metaDataObject == null ? "" : this.metaDataObject.getMainTableKey();
                if (!mainTableKey.equals(key)) continue;
            }
            DataTable srcTable = (DataTable)entry.getValue();
            DataTable shadowTable = (DataTable)this.shadowTableMap.get((Object)key);
            DataTable jsonTable = this.withShadowTable ? (shadowTable != null ? shadowTable : srcTable) : srcTable;
            this.setDefaultValue(key, jsonTable);
            JSONObject tableJSON = jsonTable.toJSON();
            JSONHelper.writeToJSON((JSONObject)tableJSON, (String)"key", (String)key, (String)"");
            if (this.metaDataObject != null && (metaTable = this.metaDataObject.getMetaTable(key)) != null) {
                tableJSON.put("parentKey", (Object)metaTable.getParentKey());
                tableJSON.put("isT", metaTable.isT());
                tableJSON.put("tableMode", metaTable.getTableMode());
                tableJSON.put("isPersist", metaTable.isPersist());
            }
            tableArray.put((Object)tableJSON);
        }
        jsonObj.put("table_list", (Object)tableArray);
        JSONObject jsonExpandData = new JSONObject();
        jsonObj.put("expand_data", (Object)jsonExpandData);
        JSONObject jsonExpandDataType = new JSONObject();
        jsonObj.put("expand_data_type", (Object)jsonExpandDataType);
        JSONObject jsonExpandDataClass = new JSONObject();
        jsonObj.put("expand_data_class", (Object)jsonExpandDataClass);
        for (Map.Entry e : this.expandData.entrySet()) {
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (value instanceof String) {
                jsonExpandDataType.put(key, 3);
                jsonExpandData.put(key, value);
                continue;
            }
            if (value instanceof Integer) {
                jsonExpandDataType.put(key, 1);
                jsonExpandData.put(key, value);
                continue;
            }
            if (value instanceof Long) {
                jsonExpandDataType.put(key, 2);
                jsonExpandData.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                jsonExpandDataType.put(key, 14);
                JSONObject o = new JSONObject((Map)value);
                jsonExpandData.put(key, (Object)o);
                continue;
            }
            if (value instanceof JSONObject) {
                jsonExpandDataType.put(key, 10);
                jsonExpandData.put(key, value);
                continue;
            }
            if (!(value instanceof JSONSerializable)) continue;
            jsonExpandDataType.put(key, 7);
            JSONSerializable js = (JSONSerializable)value;
            jsonExpandData.put(key, (Object)js.toJSON());
            jsonExpandDataClass.put(key, (Object)value.getClass().getName());
        }
        jsonObj.put("isDoc", true);
        return jsonObj;
    }

    private void setDefaultValue(String key, DataTable dataTable) {
        if (this.metaDataObject == null) {
            return;
        }
        MetaTable metaTable = this.metaDataObject.getMetaTable(key);
        if (metaTable == null) {
            return;
        }
        Iterator itColumn = metaTable.iterator();
        int index = 0;
        String defaultValue = null;
        DataTableMetaData tableMetaData = dataTable.getMetaData();
        int columnCount = tableMetaData.getColumnCount();
        while (itColumn.hasNext()) {
            MetaColumn metaColumn = (MetaColumn)itColumn.next();
            if (index >= columnCount) break;
            defaultValue = metaColumn.getDefaultValue();
            if (defaultValue != null && !defaultValue.isEmpty()) {
                dataTable.getMetaData().getColumnInfo(index).setDefaultValue(defaultValue);
            }
            ++index;
        }
    }

    public void fromJSON(JSONObject jsonObj) throws Throwable {
        this.objectKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"object_key", (String)"");
        this.OID = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"oid", (long)-1L);
        this.POID = !jsonObj.has("poid") ? null : Long.valueOf(jsonObj.getLong("poid"));
        this.VERID = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"verid", (int)0);
        this.DVERID = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"dverid", (int)0);
        this.state = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"state", (int)0);
        this.documentType = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"document_type", (int)1);
        JSONArray tableArray = jsonObj.getJSONArray("table_list");
        this.tableList.clear();
        this.dataTableMap.clear();
        this.shadowTableMap.clear();
        for (int i = 0; i < tableArray.length(); ++i) {
            JSONObject tableObj = tableArray.getJSONObject(i);
            String tableKey = JSONHelper.readFromJSON((JSONObject)tableObj, (String)"key", (String)"");
            DataTable dataTable = new DataTable();
            dataTable.fromJSON(tableObj);
            this.tableList.add(dataTable);
            this.dataTableMap.put((Object)tableKey, (Object)dataTable);
        }
        if (!jsonObj.isNull("expand_data")) {
            JSONObject jsonExpandData = jsonObj.getJSONObject("expand_data");
            JSONObject jsonExpandDataType = jsonObj.getJSONObject("expand_data_type");
            JSONObject jsonExpandDataClass = jsonObj.getJSONObject("expand_data_class");
            Iterator it = jsonExpandData.keys();
            while (it.hasNext()) {
                String key = it.next().toString();
                int type = jsonExpandDataType.getInt(key);
                switch (type) {
                    case 1: {
                        this.expandData.put((Object)key, (Object)jsonExpandData.getInt(key));
                        break;
                    }
                    case 2: {
                        this.expandData.put((Object)key, (Object)jsonExpandData.getLong(key));
                        break;
                    }
                    case 3: {
                        this.expandData.put((Object)key, (Object)jsonExpandData.getString(key));
                        break;
                    }
                    case 14: {
                        JSONObject json = jsonExpandData.optJSONObject(key);
                        HashMap<String, Object> params = null;
                        if (json != null) {
                            params = new HashMap<String, Object>();
                            Iterator v = json.keys();
                            while (v.hasNext()) {
                                Object o = v.next();
                                String k = TypeConvertor.toString(o);
                                params.put(k, json.opt(k));
                            }
                        }
                        this.expandData.put((Object)key, params);
                        break;
                    }
                    case 10: {
                        this.expandData.put((Object)key, (Object)jsonExpandData.optJSONObject(key));
                        break;
                    }
                    case 7: {
                        JSONObject value = jsonExpandData.optJSONObject(key);
                        if (value == null) {
                            this.expandData.put((Object)key, (Object)value);
                            break;
                        }
                        String className = jsonExpandDataClass.getString(key);
                        JSONSerializable js = (JSONSerializable)Class.forName(className).newInstance();
                        js.fromJSON(jsonExpandData.getJSONObject(key));
                        this.expandData.put((Object)key, (Object)js);
                    }
                }
            }
        }
    }

    public void batchUpdate() throws Throwable {
        this.batchUpdate(false);
    }

    @Deprecated
    public void batchUpdate(boolean reserveOrgData) throws Throwable {
        for (int i = 0; i < this.tableList.size(); ++i) {
            DataTable table = this.tableList.get(i);
            table.setShowDeletedFlag(false);
            table.batchUpdate(reserveOrgData);
        }
    }

    @Deprecated
    public void clearOriginalData() {
        for (int i = 0; i < this.tableList.size(); ++i) {
            DataTable table = this.tableList.get(i);
            table.clearOriginalData();
        }
    }

    public void moveFirst() {
        for (int i = 0; i < this.tableList.size(); ++i) {
            DataTable table = this.tableList.get(i);
            table.first();
        }
    }

    public Document deepClone() {
        Document clone = new Document(this.metaDataObject, this.OID);
        clone.setObjectKey(this.objectKey);
        clone.setPOID(this.POID);
        clone.setVERID(this.VERID);
        clone.setDVERID(this.DVERID);
        MetaTableCollection metaTableCollection = this.metaDataObject.getTableCollection();
        Iterator it = metaTableCollection.iterator();
        MetaTable metaTable = null;
        int index = 0;
        DataTable table = null;
        while (it.hasNext()) {
            metaTable = (MetaTable)it.next();
            table = this.get(index);
            clone.add(metaTable.getKey(), table.deepClone());
            ++index;
        }
        clone.state = this.state;
        clone.setDocumentType(this.documentType);
        String key = null;
        Object value = null;
        for (Map.Entry e : this.expandData.entrySet()) {
            key = (String)e.getKey();
            value = e.getValue();
            clone.putExpandData(key, value);
        }
        return clone;
    }

    @Override
    public IJSONHandler newHandler(String token) {
        if ("table_list".equals(token)) {
            return new DataTableListImpl(this);
        }
        if ("expand_data_class".equals(token)) {
            return new ExpandDataClassImpl();
        }
        if ("expand_data".equals(token)) {
            return new ExpandDataImpl();
        }
        if ("expand_data_type".equals(token)) {
            return new ExpandDataTypeImpl();
        }
        return this;
    }

    @Override
    public void putAttr(String name, String value) {
        if ("object_key".equals(name)) {
            this.objectKey = value;
        } else if ("state".equals(name)) {
            this.state = Integer.parseInt(value);
        }
    }

    @Override
    public void endHandler() {
    }

    @Override
    public void endChildHandler(IJSONHandler handler) {
    }

    public void close() {
        Iterator<DataTable> it = this.tableList.iterator();
        DataTable t = null;
        while (it.hasNext()) {
            t = it.next();
            t.close();
        }
    }
}

