/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.dict;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.struct.dict.ItemRow;
import com.bokesoft.yes.struct.dict.ItemTableBase;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.dict.BaseItem;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.exception.StructException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Item
implements JSONSerializable,
Serializable {
    private static final long serialVersionUID = -7640509081419239905L;
    private Map<String, ItemTableBase> itemTables = new HashMap<String, ItemTableBase>();
    private long OID;
    private int nodeType;
    private int enable;
    private String itemKey = "";
    private String caption = "";
    private String mainTableKey = "";
    private boolean hasInited = false;

    public Item() {
    }

    public Item(String itemKey, long id) {
        this.itemKey = itemKey;
        this.OID = id;
        if (id == 0L) {
            this.nodeType = 1;
        }
    }

    public Item(JSONObject jsonObj) throws JSONException {
        try {
            this.fromJSON(jsonObj);
        }
        catch (StructException e) {
            e.printStackTrace();
            throw new RuntimeException("Item json \u5e8f\u5217\u5316\u9519\u8bef:" + jsonObj);
        }
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public long getID() {
        return this.OID;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public long getParentID() {
        return TypeConvertor.toLong((Object)this.getValue("ParentID"));
    }

    public int getEnable() {
        return this.enable;
    }

    public ItemTableBase getItemTable(String tableKey) {
        return this.itemTables.get(tableKey);
    }

    public Map<String, ItemTableBase> getItemTables() {
        return this.itemTables;
    }

    public Object getValue(String tableKey, String colKey) {
        ItemTableBase tableBase = this.itemTables.get(tableKey);
        if (tableBase == null) {
            return null;
        }
        return tableBase.getValue(colKey);
    }

    public static void main(String[] args) {
        String a = "zfw.nana";
        int pos = a.indexOf(46);
        String b = a.substring(0, pos);
        String c = a.substring(pos + 1);
    }

    public Object getValue(String colKey) {
        String tableKey = null;
        int pos = colKey.indexOf(46);
        if (pos > 0) {
            tableKey = colKey.substring(0, pos);
            colKey = colKey.substring(pos + 1);
        } else {
            tableKey = this.mainTableKey;
        }
        return this.getValue(tableKey, colKey);
    }

    public Object impl_getValue(String tableKey, String colKey) {
        ItemTableBase tableBase = this.itemTables.get(tableKey);
        if (tableBase == null) {
            return null;
        }
        return tableBase.impl_getValue(colKey);
    }

    public Object impl_getValue(String colKey) {
        String tableKey = null;
        int pos = colKey.indexOf(46);
        if (pos > 0) {
            tableKey = colKey.substring(0, pos);
            colKey = colKey.substring(pos + 1);
        } else {
            tableKey = this.mainTableKey;
        }
        return this.impl_getValue(tableKey, colKey);
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String s) {
        this.caption = s;
    }

    public void addItemTableBase(ItemTableBase tb, boolean isMainTable) {
        this.itemTables.put(tb.getKey(), tb);
        if (isMainTable) {
            this.mainTableKey = tb.getKey();
            if (this.hasInited) {
                throw new RuntimeException("\u5df2\u7ecf\u521d\u59cb\u5316\u8fc7\uff0c \u4e0d\u5e94\u8be5\u518d\u521d\u59cb\u5316\u6570\u636e\u3002");
            }
            this.initData(tb);
        }
    }

    private void initData(ItemTableBase tb) {
        this.OID = this.OID == 0L ? TypeConvertor.toLong((Object)tb.getValue("OID")) : this.OID;
        this.nodeType = TypeConvertor.toInteger((Object)tb.getValue("NodeType"));
        this.itemKey = tb.getItemKey();
        this.enable = TypeConvertor.toInteger((Object)tb.getValue("Enable"));
        this.hasInited = true;
    }

    public JSONObject toJSON() throws SerializationException, JSONException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("itemKey", (Object)this.getItemKey());
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"oid", (long)this.OID, (long)0L);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"nodeType", (int)this.nodeType, (int)0);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"enable", (int)this.enable, (int)0);
        jsonObj.put("caption", (Object)this.caption);
        jsonObj.put("mainTableKey", (Object)this.mainTableKey);
        JSONObject jsonTables = new JSONObject();
        for (String sKey : this.itemTables.keySet()) {
            if (sKey.endsWith("_T")) continue;
            ItemTableBase table = this.itemTables.get(sKey);
            JSONObject itemTableObject = table.toJSON();
            jsonTables.put(sKey, (Object)itemTableObject);
        }
        jsonObj.put("itemTables", (Object)jsonTables);
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
        this.OID = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"oid", (int)0);
        this.itemKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"itemKey", (String)"");
        this.nodeType = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"nodeType", (int)0);
        this.enable = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"enable", (int)0);
        this.caption = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"caption", (String)"");
        this.mainTableKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"mainTableKey", (String)"");
        JSONObject jsonTables = jsonObj.getJSONObject("itemTables");
        this.itemTables.clear();
        Iterator it = jsonTables.keys();
        String key = null;
        while (it.hasNext()) {
            key = (String)it.next();
            JSONObject tableObj = jsonTables.getJSONObject(key);
            ItemTableBase table = new ItemTableBase(tableObj);
            this.itemTables.put(table.getKey(), table);
        }
    }

    public String toString() {
        return this.getItemKey() + "_" + this.OID;
    }

    public ItemData toItemData() {
        return new ItemData(this.getItemKey(), this.OID);
    }

    public BaseItem toBaseItem() {
        List<ItemRow> list;
        BaseItem baseItem = new BaseItem(this.getItemKey(), this.OID);
        baseItem.setCaption(this.caption);
        baseItem.setEnable(this.enable);
        baseItem.setNodeType(this.nodeType);
        ItemTableBase mainTableBase = this.itemTables.get(this.mainTableKey);
        if (mainTableBase != null && (list = mainTableBase.getRows()) != null && !list.isEmpty()) {
            ItemRow row = list.get(0);
            String key = null;
            Object value = null;
            for (Map.Entry<String, Object> entry : row.getEntrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                baseItem.setValue(key, value);
            }
        }
        return baseItem;
    }

    public boolean equals(Item o) {
        if (o == null) {
            return false;
        }
        return this.toString().equalsIgnoreCase(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void writeObject(ObjectOutputStream out) {
        try {
            out.writeUTF(this.itemKey);
            out.writeLong(this.OID);
            out.writeInt(this.nodeType);
            out.writeInt(this.enable);
            out.writeObject(this.itemTables);
            out.writeUTF(this.mainTableKey);
            out.writeUTF(this.caption);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream in) {
        try {
            this.itemKey = in.readUTF();
            this.OID = in.readLong();
            this.nodeType = in.readInt();
            this.enable = in.readInt();
            this.itemTables = (HashMap)in.readObject();
            this.mainTableKey = in.readUTF();
            this.caption = in.readUTF();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Item clone() {
        Item i = new Item();
        i.itemKey = this.itemKey;
        i.OID = this.OID;
        i.nodeType = this.nodeType;
        i.enable = this.enable;
        HashMap<String, ItemTableBase> map = new HashMap<String, ItemTableBase>();
        for (ItemTableBase itb : this.itemTables.values()) {
            map.put(itb.getKey(), itb.clone());
        }
        i.itemTables = map;
        i.mainTableKey = this.mainTableKey;
        return i;
    }
}

