/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.datatable;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.struct.datatype.DataTypeAction;
import com.bokesoft.yes.struct.datatype.DataTypeActionFactory;
import com.bokesoft.yes.struct.document.IJSONHandler;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.struct.exception.StructException;
import org.json.JSONException;
import org.json.JSONObject;

public class ColumnInfo
implements JSONSerializable,
IJSONHandler {
    private boolean hasReadRights = true;
    private boolean hasWriteRights = true;
    private int columnIndex = -1;
    private String columnKey;
    private int userDataType;
    private int dataType;
    private DataTypeAction dataTypeAction = null;
    private boolean accessControl = false;
    private String defaultValue = null;
    private boolean isPrimary = false;
    private int scale = -1;
    private int length = 0;
    private String codeColumnKey = "";

    public ColumnInfo(String columnKey, int dataType) throws StructException {
        this.columnKey = columnKey.intern();
        this.dataType = dataType;
        if (dataType == 1002) {
            this.length = 255;
        }
        this.userDataType = DBTypeUtil.dataType2JavaDataType((int)dataType);
        this.dataTypeAction = DataTypeActionFactory.getDataType(this.userDataType);
    }

    ColumnInfo() {
    }

    public String getColumnKey() {
        return this.columnKey;
    }

    public DataTypeAction getDataTypeAction() {
        return this.dataTypeAction;
    }

    public ColumnInfo deepClone() {
        ColumnInfo clone = new ColumnInfo();
        clone.dataType = this.dataType;
        clone.columnKey = this.columnKey;
        clone.userDataType = this.userDataType;
        clone.dataTypeAction = this.dataTypeAction;
        clone.columnIndex = this.columnIndex;
        clone.accessControl = this.accessControl;
        clone.scale = this.scale;
        clone.length = this.length;
        clone.codeColumnKey = this.codeColumnKey;
        return clone;
    }

    public JSONObject toJSON() throws SerializationException, JSONException {
        JSONObject jsonObj = new JSONObject();
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"key", (String)this.columnKey, (String)"");
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"data_type", (int)this.dataType, (int)-1);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"user_type", (int)this.userDataType, (int)-1);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"index", (int)this.columnIndex, (int)-1);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"accesscontrol", (boolean)this.accessControl, (boolean)false);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"defaultValue", (String)this.defaultValue, null);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"isPrimary", (boolean)this.isPrimary, (boolean)false);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"scale", (int)this.scale, (int)-1);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"length", (int)this.length, (int)0);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"codeColumnKey", (String)this.codeColumnKey, (String)"");
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
        this.columnKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"key", (String)"");
        this.dataType = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"data_type", (int)-1);
        this.userDataType = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"user_type", (int)-1);
        this.dataTypeAction = DataTypeActionFactory.getDataType(this.userDataType);
        this.columnIndex = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"index", (int)-1);
        this.accessControl = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"accesscontrol", (boolean)false);
        this.defaultValue = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"defaultValue", null);
        this.isPrimary = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"isPrimary", (boolean)false);
        this.scale = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"scale", (int)-1);
        this.length = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"length", (int)0);
        this.codeColumnKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"codeColumnKey", (String)"");
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getUserDataType() {
        return this.userDataType;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public boolean isAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(boolean accessControl) {
        this.accessControl = accessControl;
    }

    public void setDefaultValue(String defaultValue) {
        if (defaultValue != null) {
            defaultValue = defaultValue.intern();
        }
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public String getCodeColumnKey() {
        return this.codeColumnKey;
    }

    public void setCodeColumnKey(String codeColumnKey) {
        if (codeColumnKey != null) {
            codeColumnKey = codeColumnKey.intern();
        }
        this.codeColumnKey = codeColumnKey;
    }

    @Override
    public IJSONHandler newHandler(String token) {
        return null;
    }

    @Override
    public void putAttr(String name, String value) {
        if ("user_type".equals(name)) {
            this.userDataType = Integer.parseInt(value);
            this.dataTypeAction = DataTypeActionFactory.getDataType(this.userDataType);
        } else if ("data_type".equals(name)) {
            this.dataType = Integer.parseInt(value);
        } else if ("key".equals(name)) {
            this.columnKey = value;
        } else if ("index".equals(name)) {
            this.columnIndex = Integer.parseInt(value);
        } else if ("accesscontrol".equals(name)) {
            this.accessControl = Boolean.parseBoolean(value);
        }
    }

    @Override
    public void endHandler() {
    }

    @Override
    public void endChildHandler(IJSONHandler handler) {
    }

    public boolean isHasReadRights() {
        return this.hasReadRights;
    }

    public void setHasReadRights(boolean hasReadRights) {
        this.hasReadRights = hasReadRights;
    }

    public boolean isHasWriteRights() {
        return this.hasWriteRights;
    }

    public void setHasWriteRights(boolean hasWriteRights) {
        this.hasWriteRights = hasWriteRights;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

